/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.system;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.helper.ThreadHelper;
import com.techempower.log.ComponentLog;
import com.techempower.thread.EndableThread;

public class ThreadPauseResume
extends BasicAdminFunction {
    public ThreadPauseResume() {
        super("thread-pause", "Thread Pause", "Pause / resume a running thread", "system", false, false);
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        Thread thread;
        boolean pause = context.query().getInt("pause") == 1;
        long id = context.query().getInt("id", -1);
        if (id >= 0L && (thread = ThreadHelper.getThread(id)) != null && thread instanceof EndableThread) {
            EndableThread et = (EndableThread)thread;
            et.setPaused(pause);
            if (pause) {
                context.messages().normal(String.valueOf(et.getName()) + " PAUSED.");
                log.log(String.valueOf(et.getName()) + " paused.");
            } else {
                context.messages().normal(String.valueOf(et.getName()) + " RESUMED.");
                log.log(String.valueOf(et.getName()) + " resumed.");
            }
            return bah.redirectRelative(bah.getFunction("system-thread-list").getRelativeUri());
        }
        context.messages().warning("Threads that are not EndableThread subclasses cannot be paused.");
        return bah.redirectRelative(bah.getFunction("system-thread-list").getRelativeUri());
    }
}

