/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.users;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.pyxis.PyxisUserGroup;
import com.techempower.log.ComponentLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GroupList
extends BasicAdminFunction {
    public GroupList() {
        super("group-list", "Group List", "List and manage user groups", "users", true, false);
    }

    public static boolean isBuiltIn(PyxisUserGroup group) {
        return group.getType() == 0 || group.getType() == 1;
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        List<PyxisUserGroup> groups = app.getStore().sortedList(bah.getUserGroupClass(), "getGroupID", 2);
        ArrayList groupMap = new ArrayList();
        for (PyxisUserGroup group : groups) {
            HashMap<String, Object> aGroup = new HashMap<String, Object>();
            aGroup.put("group", group);
            aGroup.put("builtIn", GroupList.isBuiltIn(group));
            groupMap.add(aGroup);
        }
        context.delivery().putObject("groups", groupMap);
        return bah.mustache(this.getTemplateName());
    }
}

