/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.users;

import com.techempower.data.util.ObjectColumn;
import com.techempower.data.util.TabularColumn;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.AdminFunction;
import com.techempower.gemini.admin.AdminFunctionCategory;
import com.techempower.gemini.admin.standard.users.GroupEdit;
import com.techempower.gemini.admin.standard.users.GroupList;
import com.techempower.gemini.admin.standard.users.GroupMembership;
import com.techempower.gemini.admin.standard.users.UserEdit;
import com.techempower.gemini.admin.standard.users.UserList;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormCheckBox;
import com.techempower.gemini.form.FormComplexDateField;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormHidden;
import com.techempower.gemini.form.FormNonce;
import com.techempower.gemini.form.FormPasswordField;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormSubmitButton;
import com.techempower.gemini.form.FormTextField;
import com.techempower.gemini.form.FormUsernameField;
import com.techempower.gemini.form.FormValidation;
import com.techempower.gemini.form.FormValidator;
import com.techempower.gemini.form.FormValues;
import com.techempower.gemini.form.PostOnlyForm;
import com.techempower.gemini.form.processor.Lowercase;
import com.techempower.gemini.form.validator.CacheUniquenessValidator;
import com.techempower.gemini.pyxis.BasicSecurity;
import com.techempower.gemini.pyxis.BasicWebUser;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.gemini.pyxis.PyxisUserGroup;
import com.techempower.helper.DateHelper;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class UserCategory
extends AdminFunctionCategory {
    public static final String SESSION_ADMIN_UL = "GeminiAdmin-Userlist-Options";

    public UserCategory() {
        super("users", "User Management");
    }

    @Override
    public AdminFunction[] getStandardFunctions() {
        return new AdminFunction[]{new UserList(), new UserEdit(), new GroupMembership(), new GroupEdit(), new GroupList()};
    }

    protected Form buildAddEditUserForm(GeminiApplication app, Context context, BasicWebUser user) {
        PostOnlyForm form = new PostOnlyForm(app, "EditUserForm", context.getUrl(), "post");
        form.setAdditionalAttributes("autocomplete=\"off\"");
        form.add(new FormHidden("cmd", "admin-user-edit", true));
        form.add(new FormHidden("id", "" + user.getId(), true));
        FormElement element = new FormUsernameField("newun", user.getUserUsername(), true, 4, 45, 100).setDisplayName("Username").addProcessor(Lowercase.INSTANCE);
        element.addValidator(new CacheUniquenessValidator(app.getStore(), app.getSecurity().getUserClass(), "getUserUsername", user));
        form.add(element);
        element = new FormPasswordField("newpw", "", false, 45, 30).setMinLength(4).setDisplayName("Password");
        form.add(element);
        element = new FormTextField("newem", user.getUserEmail(), false, 45, 254).setDisplayName("Email Address").addProcessor(Lowercase.INSTANCE);
        element.addValidator(new CacheUniquenessValidator(app.getStore(), app.getSecurity().getUserClass(), "getUserEmail", user));
        form.add(element);
        element = new FormTextField("first", user.getUserFirstname(), true, 45, 50).setDisplayName("First Name").addProcessor(Lowercase.INSTANCE);
        form.add(element);
        element = new FormTextField("last", user.getUserLastname(), true, 45, 50).setDisplayName("Last Name").addProcessor(Lowercase.INSTANCE);
        form.add(element);
        element = new FormComplexDateField("lastlogin", user.getUserLastLogin() != null ? DateHelper.STANDARD_US_DATE_FORMAT.format(user.getUserLastLogin()) : null, false, 45);
        element.setDisplayName("Last Login");
        form.add(element);
        element = new FormCheckBox("enabled", "", false, user.isEnabled());
        element.setDisplayName("Enabled");
        form.add(element);
        form.add(new FormNonce("N" + user.getId(), context));
        form.add(new FormSubmitButton("save", "Save"));
        form.add(new UniqueUsernameValidator(user));
        return form;
    }

    protected boolean saveUser(GeminiApplication app, BasicWebUser user, Form form, Context context) {
        app.getStore().put(user);
        return true;
    }

    protected boolean updateUser(BasicWebUser user, Form form, Context context) {
        FormValues values = form.values();
        user.setUserUsername(values.get("newun"));
        user.setUserFirstname(values.get("first"));
        user.setUserLastname(values.get("last"));
        user.setUserEmail(values.get("newem"));
        user.setUserLastLogin(values.getDate("lastlogin"));
        user.setEnabled(values.getBoolean("enabled"));
        String newPassword = values.get("newpw");
        if (StringHelper.isNonEmpty(newPassword)) {
            user.setUserPassword(newPassword);
        }
        return true;
    }

    protected TabularColumn[] getCustomUserListColumns() {
        return new TabularColumn[0];
    }

    protected TabularColumn[] getCustomUserDumpColumns() {
        return new ObjectColumn[0];
    }

    protected CustomUserAction[] getCustomUserActions() {
        return new CustomUserAction[0];
    }

    protected Form buildUserListForm(GeminiApplication app, Context context) {
        PostOnlyForm form = new PostOnlyForm(app, "userlist", context.getUrl(), "post");
        Options opts = (Options)context.session().getObject(SESSION_ADMIN_UL);
        if (opts == null) {
            opts = new Options();
        }
        FormUsernameField usernameElement = new FormUsernameField("Username", "username", opts.username, false, 0, 100, 100);
        form.add(usernameElement);
        FormTextField emailElement = new FormTextField("Email Address", "email", opts.email, false, 254, 254);
        form.add(emailElement);
        FormTextField firstnameElement = new FormTextField("First name", "firstname", opts.firstname, false, 50, 50);
        form.add(firstnameElement);
        FormTextField lastnameElement = new FormTextField("Last name", "lastname", opts.lastname, false, 50, 50);
        form.add(lastnameElement);
        FormElement disabledElement = new FormCheckBox("disabled", "", false, opts.includeDisabled).setDisplayName("Include disabled");
        form.add(disabledElement);
        form.add(new FormSubmitButton("filter", "Filter", true));
        return form;
    }

    protected FormValidation processUserListForm(Context context, Form form) {
        context.delivery().putObject("form", form);
        if (form.hasBeenSubmitted(context)) {
            FormValidation validation = form.validate(context);
            if (validation.isGood()) {
                Options opts = (Options)context.session().getObject(SESSION_ADMIN_UL);
                if (opts == null) {
                    opts = new Options();
                    context.session().putObject(SESSION_ADMIN_UL, opts);
                }
                opts.set(form);
            } else {
                context.delivery().putObject("validation", validation);
            }
            return validation;
        }
        return null;
    }

    protected List<BasicWebUser> filterUsers(Form form, List<BasicWebUser> userCollection) {
        boolean hd;
        Options opts = new Options();
        opts.set(form);
        boolean un = StringHelper.isNonEmpty(opts.username);
        boolean em = StringHelper.isNonEmpty(opts.email);
        boolean fn = StringHelper.isNonEmpty(opts.firstname);
        boolean ln = StringHelper.isNonEmpty(opts.lastname);
        boolean bl = hd = !opts.includeDisabled;
        if (un || em || fn || ln || hd) {
            ArrayList<BasicWebUser> toReturn = new ArrayList<BasicWebUser>();
            for (BasicWebUser user : userCollection) {
                if (hd && !user.isEnabled() || un && (user.getUserUsername() == null || user.getUserUsername().toLowerCase().indexOf(opts.username) < 0) || em && (user.getUserEmail() == null || user.getUserEmail().toLowerCase().indexOf(opts.email) < 0) || fn && (user.getUserFirstname() == null || user.getUserFirstname().toLowerCase().indexOf(opts.firstname) < 0) || ln && (user.getUserLastname() == null || user.getUserLastname().toLowerCase().indexOf(opts.lastname) < 0)) continue;
                toReturn.add(user);
            }
            return toReturn;
        }
        return userCollection;
    }

    protected static class CustomUserAction {
        protected CustomUserAction() {
        }

        protected String getValue(BasicWebUser user) {
            return "";
        }
    }

    static class Options {
        public String username = "";
        public String email = "";
        public String firstname = "";
        public String lastname = "";
        public boolean includeDisabled = false;

        Options() {
        }

        public void set(Form form) {
            FormValues values = form.values();
            this.username = values.get("username");
            this.email = values.get("email");
            this.firstname = values.get("firstname");
            this.lastname = values.get("lastname");
            this.includeDisabled = values.getBoolean("disabled");
        }
    }

    static class UniqueUsernameValidator
    extends FormValidator {
        public UniqueUsernameValidator(Object referenceObject) {
            super(referenceObject);
        }

        @Override
        public void validate(Form form, Context context, FormSingleValidation val) {
            BasicWebUser user;
            BasicSecurity<? extends PyxisUser, ? extends PyxisUserGroup> security;
            BasicWebUser byUsername;
            String newUsername = form.values().get("newun");
            if (StringHelper.isNonEmpty(newUsername) && (byUsername = (BasicWebUser)(security = (user = (BasicWebUser)this.getReferenceObject()).getSecurity()).getUser(newUsername)) != null && byUsername.getId() != user.getId()) {
                val.setRawError("The username " + NetworkHelper.render(newUsername) + " is already taken.", "Please provide a different username.", "This username is already taken.");
            }
        }
    }
}

