/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.admin.standard.users;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.admin.BasicAdminFunction;
import com.techempower.gemini.admin.BasicAdminHandler;
import com.techempower.gemini.admin.standard.users.UserCategory;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormNonce;
import com.techempower.gemini.form.FormValidation;
import com.techempower.gemini.pyxis.BasicWebUser;
import com.techempower.log.ComponentLog;

public class UserEdit
extends BasicAdminFunction {
    public UserEdit() {
        super("user-edit", "Create User", "Create a new user", "users");
    }

    @Override
    public boolean handle(Context context, BasicAdminHandler<?> bah, GeminiApplication app, ComponentLog log) {
        UserCategory cat = (UserCategory)bah.getFunctionCategory("users");
        int id = context.query().getInt("id");
        BasicWebUser user = bah.getUser(id);
        if (user == null) {
            user = (BasicWebUser)app.getSecurity().constructUser();
            user.initialize();
        }
        Form form = cat.buildAddEditUserForm(app, context, user);
        context.delivery().putObject("form", form).putObject("User", user);
        for (FormElement element : form.getList()) {
            if (!(element instanceof FormNonce)) continue;
            context.delivery().putObject("nonce", element);
        }
        if (form.hasBeenSubmitted(context)) {
            FormValidation validation = form.validate(context);
            if (validation.isGood()) {
                if (cat.updateUser(user, form, context)) {
                    if (cat.saveUser(app, user, form, context)) {
                        log.log("Saved user " + user.getId());
                        context.messages().success("User " + user.getUserUsername() + " saved.");
                        return bah.redirectRelative(String.valueOf(this.getRelativeUri()) + "?id=" + user.getId());
                    }
                    log.log("Unable to save user " + user.getId(), 70);
                    return bah.handleInformation(context, 10, "Unable to save user " + user.getUserUsername() + ".");
                }
            } else {
                context.delivery().putObject("validation", validation);
            }
        }
        return bah.mustache(this.getTemplateName());
    }
}

