/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.annotation.intercept;

import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.LegacyContext;
import com.techempower.gemini.annotation.intercept.HandlerIntercept;
import com.techempower.gemini.annotation.intercept.RequireGroup;
import com.techempower.gemini.pyxis.PyxisSecurity;
import com.techempower.gemini.pyxis.PyxisUser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class GroupIntercept<D extends BasicDispatcher, C extends LegacyContext>
implements HandlerIntercept<D, C> {
    public GroupIntercept(GeminiApplication application) {
    }

    @Override
    public boolean intercept(Method m, D dispatcher, C context, String command, Annotation annotation) {
        PyxisSecurity security = ((Context)context).getApplication().getSecurity();
        if (security == null) {
            return false;
        }
        PyxisUser user = security.getUser((Context)context);
        if (user == null) {
            return false;
        }
        int[] groups = ((RequireGroup)annotation).allOf();
        boolean inGroups = true;
        int i = 0;
        while (i < groups.length) {
            if (!user.isMember(groups[i])) {
                inGroups = false;
                break;
            }
            ++i;
        }
        groups = ((RequireGroup)annotation).anyOf();
        if (inGroups && groups.length > 0) {
            inGroups = false;
            i = 0;
            while (i < groups.length) {
                if (user.isMember(groups[i])) {
                    inGroups = true;
                    break;
                }
                ++i;
            }
        }
        return !inGroups;
    }

    @Override
    public boolean handleIntercept(Method m, D dispatcher, C context, String command, Annotation annotation) {
        String msg = ((RequireGroup)annotation).msg();
        if (msg != null) {
            ((Context)context).delivery().put("Message", msg);
        }
        return ((LegacyContext)context).render(((RequireGroup)annotation).jsp());
    }
}

