/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.annotation.intercept;

import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Handler;
import com.techempower.gemini.annotation.intercept.HandlerIntercept;
import com.techempower.gemini.annotation.intercept.RequireLogin;
import com.techempower.gemini.pyxis.PyxisSecurity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class LoginIntercept
implements HandlerIntercept<BasicDispatcher, Context> {
    private GeminiApplication application;

    public LoginIntercept(GeminiApplication application) {
        this.application = application;
    }

    @Override
    public boolean intercept(Method m, BasicDispatcher dispatcher, Context context, String command, Annotation annotation) {
        PyxisSecurity security = this.application.getSecurity();
        return security != null && !security.isLoggedIn(context);
    }

    @Override
    public boolean handleIntercept(Method m, BasicDispatcher dispatcher, Context context, String command, Annotation annotation) {
        Handler<? extends BasicDispatcher, ? extends Context> handler = dispatcher.getRoledHandler(((RequireLogin)annotation).value());
        if (handler != null) {
            return handler.handleRequest(dispatcher, context, command);
        }
        return false;
    }
}

