/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster;

import com.techempower.gemini.cluster.server.ServerConnection;

public abstract class Message
implements Comparable<Message> {
    private long messageId;
    private int sourceNode;
    private transient ServerConnection relatedConnection;
    private transient boolean omitRelated;
    private int channel;

    public long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(long id) {
        this.messageId = id;
    }

    public int getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(int sourceNode) {
        this.sourceNode = sourceNode;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public ServerConnection getOmittedConnection() {
        if (this.omitRelated && this.relatedConnection != null) {
            return this.relatedConnection;
        }
        return null;
    }

    public ServerConnection getExclusiveConnection() {
        if (!this.omitRelated && this.relatedConnection != null) {
            return this.relatedConnection;
        }
        return null;
    }

    public void setOmittedConnection(ServerConnection omittedConnection) {
        this.relatedConnection = omittedConnection;
        this.omitRelated = true;
    }

    public void setExclusiveConnection(ServerConnection exclusiveConnection) {
        this.relatedConnection = exclusiveConnection;
        this.omitRelated = false;
    }

    @Override
    public int compareTo(Message other) {
        return this.getSourceNode() - other.getSourceNode();
    }

    public String toString() {
        return "Message [" + this.hashCode() + "; " + this.messageId + "; " + this.sourceNode + "]";
    }
}

