/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster;

import com.techempower.TechEmpowerApplication;
import com.techempower.gemini.cluster.BroadcastMessage;
import com.techempower.gemini.cluster.Message;
import com.techempower.gemini.cluster.MessageQueue;
import com.techempower.gemini.cluster.NotificationMessage;
import com.techempower.gemini.cluster.RequestMessage;
import com.techempower.gemini.cluster.ResponseMessage;
import com.techempower.gemini.cluster.WaitingThread;
import com.techempower.log.ComponentLog;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class MessageProcessor {
    private static final Class<?>[] TRANSPORT_CONSTRUCTOR_ARGS = new Class[]{TechEmpowerApplication.class};
    private final MessageQueue outbound;
    private final ComponentLog log;
    private final AtomicLong messageCounter = new AtomicLong();
    private final ConcurrentHashMap<Long, WaitingThread> waiting;
    private String authenticationKey = "dev";
    private long authenticationTimeout = 10000L;
    private int nodeId = 0;

    protected static Class<?>[] getTransportConstructorArguments() {
        return TRANSPORT_CONSTRUCTOR_ARGS;
    }

    public MessageProcessor(TechEmpowerApplication application) {
        this.log = application.getLog("clus");
        this.outbound = new MessageQueue();
        this.messageCounter.set(0L);
        this.waiting = new ConcurrentHashMap();
    }

    public boolean isEnabled() {
        return true;
    }

    protected void addToOutboundQueue(Message message) {
        if (this.isEnabled()) {
            this.outbound.add(message);
        }
    }

    protected void markOutboundMessage(Message message) {
        if (message.getMessageId() == 0L) {
            message.setSourceNode(this.nodeId);
            message.setMessageId(this.messageCounter.incrementAndGet());
        }
    }

    public void send(BroadcastMessage message) {
        this.markOutboundMessage(message);
        this.addToOutboundQueue(message);
    }

    public void send(NotificationMessage message) {
        this.markOutboundMessage(message);
        this.addToOutboundQueue(message);
    }

    public void sendResponse(RequestMessage request, ResponseMessage response) {
        response.setRequestId(request.getMessageId());
        this.markOutboundMessage(response);
        this.addToOutboundQueue(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ResponseMessage> send(RequestMessage request) {
        this.markOutboundMessage(request);
        WaitingThread thread = new WaitingThread(request);
        this.waiting.put(request.getMessageId(), thread);
        try {
            block13: {
                block12: {
                    this.addToOutboundQueue(request);
                    request.captureSentTime();
                    if (!true) break block12;
                    if (thread.reachedExpectedResponseCount()) return thread.getResponses();
                    if (request.getRequestTimeoutRemaining() <= 0L) break block13;
                }
                do {
                    try {
                        WaitingThread waitingThread = thread;
                        synchronized (waitingThread) {
                            long timeout = request.getRequestTimeoutRemaining();
                            if (timeout >= 1L) {
                                thread.wait(timeout);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (thread.reachedExpectedResponseCount()) return thread.getResponses();
                } while (request.getRequestTimeoutRemaining() > 0L);
            }
            return thread.getResponses();
        }
        finally {
            this.waiting.remove(request.getMessageId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wakeup(ResponseMessage response) {
        long requestId = response.getRequestId();
        WaitingThread thread = this.waiting.get(requestId);
        if (thread != null) {
            WaitingThread waitingThread = thread;
            synchronized (waitingThread) {
                thread.addResponse(response);
                if (thread.reachedExpectedResponseCount()) {
                    thread.notifyAll();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wakeupNoResponse(long requestId) {
        WaitingThread thread = this.waiting.get(requestId);
        if (thread != null) {
            WaitingThread waitingThread = thread;
            synchronized (waitingThread) {
                thread.setTimeout(true);
                thread.notifyAll();
            }
            return true;
        }
        return false;
    }

    public void setNodeId(int id) {
        this.nodeId = id;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public MessageQueue getOutbound() {
        return this.outbound;
    }

    public String getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setAuthenticationKey(String authenticationKey) {
        this.authenticationKey = authenticationKey;
    }

    public long getAuthenticationTimeout() {
        return this.authenticationTimeout;
    }

    public void setAuthenticationTimeout(long timeout) {
        this.authenticationTimeout = timeout;
    }

    protected ComponentLog getLog() {
        return this.log;
    }
}

