/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster;

import com.techempower.gemini.cluster.RequestMessage;
import com.techempower.gemini.cluster.ResponseMessage;
import java.util.ArrayList;
import java.util.List;

public class WaitingThread {
    private final Thread thread;
    private final RequestMessage request;
    private List<ResponseMessage> responses = null;
    private boolean timeout = false;

    public WaitingThread(RequestMessage request) {
        this.request = request;
        this.thread = Thread.currentThread();
    }

    public Thread getThread() {
        return this.thread;
    }

    public RequestMessage getRequestMessage() {
        return this.request;
    }

    public List<ResponseMessage> getResponses() {
        if (this.responses == null) {
            this.responses = new ArrayList<ResponseMessage>(0);
        }
        return this.responses;
    }

    public synchronized void addResponse(ResponseMessage response) {
        if (this.responses == null) {
            this.responses = new ArrayList<ResponseMessage>(this.request.getExpectedResponseCount());
        }
        this.responses.add(response);
    }

    public boolean reachedExpectedResponseCount() {
        if (this.responses == null) {
            return this.request.getExpectedResponseCount() == 0;
        }
        return this.responses.size() >= this.request.getExpectedResponseCount();
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public void setTimeout(boolean timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "WaitingClient [" + this.thread.getId() + "]";
    }
}

