/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.client.handler;

import com.techempower.cache.CacheGroup;
import com.techempower.cache.CacheListener;
import com.techempower.cache.EntityStore;
import com.techempower.data.EntityGroup;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.cluster.client.MessageHandler;
import com.techempower.gemini.cluster.message.CacheMessage;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import com.techempower.util.Identifiable;

public class CacheHandler
implements MessageHandler<CacheMessage>,
CacheListener {
    private final GeminiApplication application;
    private final ComponentLog log;
    private final EntityStore cache;

    public CacheHandler(GeminiApplication application) {
        this.application = application;
        this.log = application.getLog("clch");
        this.cache = application.getStore();
    }

    @Override
    public Class<CacheMessage> getMessageClass() {
        return CacheMessage.class;
    }

    @Override
    public boolean requiresSeparateThread() {
        return false;
    }

    @Override
    public void handle(CacheMessage message) {
        switch (message.getAction()) {
            case 3: {
                this.cache.reset(false);
                break;
            }
            case 0: {
                EntityGroup<? extends Identifiable> group = this.cache.getGroup(message.getGroupId());
                if (!(group instanceof CacheGroup)) break;
                CacheGroup cg = (CacheGroup)group;
                Object entity = cg.get(message.getObjectId());
                if (entity == null) {
                    entity = cg.newObjectFromMap(message.getObjectProperties());
                    cg.addToCache(new Identifiable[]{entity});
                    break;
                }
                cg.updateObjectFromMap(entity, message.getObjectProperties());
                cg.reorder(entity.getId());
                break;
            }
            case 1: {
                EntityGroup<? extends Identifiable> group = this.cache.getGroup(message.getGroupId());
                if (!(group instanceof CacheGroup)) break;
                ((CacheGroup)group).removeFromCache(message.getObjectId());
                break;
            }
            case 2: {
                this.cache.reset(this.cache.getGroup(message.getGroupId()).type(), false);
                break;
            }
            default: {
                this.log.log("Unknown CacheHandler action: " + message.getAction());
            }
        }
    }

    @Override
    public void configure(EnhancedProperties props) {
    }

    @Override
    public void cacheFullReset() {
        CacheMessage message = new CacheMessage();
        message.setAction(3);
        this.application.getClusterClient().send(message);
    }

    @Override
    public <T extends Identifiable> void cacheTypeReset(Class<T> type) {
        CacheMessage message = new CacheMessage();
        message.setAction(2);
        message.setGroupId(this.cache.getGroup(type).getGroupNumber());
        this.application.getClusterClient().send(message);
    }

    @Override
    public <T extends Identifiable> void cacheObjectExpired(Class<T> type, int identifier) {
        EntityGroup<T> group = this.cache.getGroup(type);
        T entity = group.get(identifier);
        if (entity != null) {
            CacheMessage message = new CacheMessage();
            message.setAction(0);
            message.setGroupId(this.cache.getGroup(type).getGroupNumber());
            message.setObjectId(identifier);
            message.setObjectProperties(group.writeMap(entity));
            this.application.getClusterClient().send(message);
        }
    }

    @Override
    public <T extends Identifiable> void removeFromCache(Class<T> type, int identifier) {
        CacheMessage message = new CacheMessage();
        message.setAction(2);
        message.setGroupId(this.cache.getGroup(type).getGroupNumber());
        message.setObjectId(identifier);
        this.application.getClusterClient().send(message);
    }
}

