/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.client.handler;

import com.techempower.cache.CachedRelation;
import com.techempower.cache.CachedRelationListener;
import com.techempower.collection.relation.IntegerRelation;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.cluster.client.MessageHandler;
import com.techempower.gemini.cluster.message.CachedRelationMessage;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import com.techempower.util.Identifiable;

public class CachedRelationHandler
implements MessageHandler<CachedRelationMessage>,
CachedRelationListener {
    private final GeminiApplication application;
    private final ComponentLog log;
    private int maximumRelationSize = 10000;

    public CachedRelationHandler(GeminiApplication application) {
        this.application = application;
        this.log = application.getLog("clcr");
    }

    @Override
    public Class<CachedRelationMessage> getMessageClass() {
        return CachedRelationMessage.class;
    }

    @Override
    public boolean requiresSeparateThread() {
        return false;
    }

    @Override
    public void handle(CachedRelationMessage message) {
        CachedRelation<? extends Identifiable, ? extends Identifiable> relation = this.application.getStore().getCachedRelation(message.getRelationId());
        switch (message.getAction()) {
            case 0: {
                relation.add(message.getLeftId(), message.getRightId(), false, false);
                break;
            }
            case 1: {
                relation.addAll(message.getRelation(), false, false);
                break;
            }
            case 2: {
                relation.clear(false, false);
                break;
            }
            case 3: {
                relation.remove(message.getLeftId(), message.getRightId(), false, false);
                break;
            }
            case 4: {
                relation.removeAll(message.getRelation(), false, false);
                break;
            }
            case 5: {
                relation.removeLeftValue(message.getLeftId(), false, false);
                break;
            }
            case 6: {
                relation.removeRightValue(message.getRightId(), false, false);
                break;
            }
            case 7: {
                relation.replaceAll(message.getRelation(), false, false);
                break;
            }
            case 8: {
                relation.reset(false);
                break;
            }
            default: {
                this.log.log("Unknown CachedRelationHandler action: " + message.getAction());
            }
        }
    }

    @Override
    public void configure(EnhancedProperties props) {
        String propsPrefix = "CachedRelationHandler.";
        this.maximumRelationSize = props.getIntegerProperty(String.valueOf(propsPrefix) + "MaximumRelationSize", this.maximumRelationSize);
    }

    @Override
    public void add(int relationID, int leftID, int rightID) {
        CachedRelationMessage message = new CachedRelationMessage();
        message.setAction(0);
        message.setRelationId(relationID);
        message.setLeftId(leftID);
        message.setRightId(rightID);
        this.application.getClusterClient().send(message);
    }

    @Override
    public void addAll(int relationID, IntegerRelation relation) {
        if (relation.size() > this.maximumRelationSize) {
            this.reset(relationID);
        } else {
            CachedRelationMessage message = new CachedRelationMessage();
            message.setAction(1);
            message.setRelationId(relationID);
            message.setRelation(relation);
            this.application.getClusterClient().send(message);
        }
    }

    @Override
    public void clear(int relationID) {
        CachedRelationMessage message = new CachedRelationMessage();
        message.setAction(2);
        message.setRelationId(relationID);
        this.application.getClusterClient().send(message);
    }

    @Override
    public void remove(int relationID, int leftID, int rightID) {
        CachedRelationMessage message = new CachedRelationMessage();
        message.setAction(3);
        message.setRelationId(relationID);
        message.setLeftId(leftID);
        message.setRightId(rightID);
        this.application.getClusterClient().send(message);
    }

    @Override
    public void removeAll(int relationID, IntegerRelation relation) {
        if (relation.size() > this.maximumRelationSize) {
            this.reset(relationID);
        } else {
            CachedRelationMessage message = new CachedRelationMessage();
            message.setAction(4);
            message.setRelationId(relationID);
            message.setRelation(relation);
            this.application.getClusterClient().send(message);
        }
    }

    @Override
    public void removeLeftValue(int relationID, int leftID) {
        CachedRelationMessage message = new CachedRelationMessage();
        message.setAction(5);
        message.setRelationId(relationID);
        message.setLeftId(leftID);
        this.application.getClusterClient().send(message);
    }

    @Override
    public void removeRightValue(int relationID, int rightID) {
        CachedRelationMessage message = new CachedRelationMessage();
        message.setAction(6);
        message.setRelationId(relationID);
        message.setRightId(rightID);
        this.application.getClusterClient().send(message);
    }

    @Override
    public void replaceAll(int relationID, IntegerRelation relation) {
        if (relation.size() > this.maximumRelationSize) {
            this.reset(relationID);
        } else {
            CachedRelationMessage message = new CachedRelationMessage();
            message.setAction(7);
            message.setRelationId(relationID);
            message.setRelation(relation);
            this.application.getClusterClient().send(message);
        }
    }

    @Override
    public void reset(int relationID) {
        CachedRelationMessage message = new CachedRelationMessage();
        message.setAction(8);
        message.setRelationId(relationID);
        this.application.getClusterClient().send(message);
    }
}

