/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.client.handler;

import com.techempower.asynchronous.Asynchronous;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.cluster.client.ClusterClient;
import com.techempower.gemini.cluster.client.MessageHandler;
import com.techempower.gemini.cluster.message.TestBroadcast;
import com.techempower.log.ComponentLog;
import com.techempower.thread.EndableThread;
import com.techempower.util.EnhancedProperties;
import java.util.Random;

public class TestHandler
implements MessageHandler<TestBroadcast>,
Asynchronous {
    private final GeminiApplication application;
    private final ComponentLog log;
    private final SpammerThread thread;
    private int minimumPauseMs;
    private int maximumPauseMs;

    public TestHandler(GeminiApplication application) {
        this.application = application;
        this.log = application.getLog("cHte");
        this.thread = new SpammerThread();
        application.addAsynchronous(this);
    }

    @Override
    public Class<TestBroadcast> getMessageClass() {
        return TestBroadcast.class;
    }

    @Override
    public boolean requiresSeparateThread() {
        return true;
    }

    @Override
    public void handle(TestBroadcast message) {
        this.log.log("Received " + message);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.minimumPauseMs = props.getIntegerProperty("TestHandler.MinimumPauseMs", 0);
        this.maximumPauseMs = props.getIntegerProperty("TestHandler.MaximumPauseMs", 5000);
    }

    public int getMinimumPause() {
        return this.minimumPauseMs;
    }

    public int getMaximumPause() {
        return this.maximumPauseMs;
    }

    @Override
    public void begin() {
        this.end();
        this.thread.begin();
    }

    @Override
    public void end() {
        this.thread.end();
    }

    class SpammerThread
    extends EndableThread {
        private Random random;

        public SpammerThread() {
            super("Cluster client test/spammer thread");
            this.random = new Random();
        }

        @Override
        public void run() {
            TestHandler.this.log.log("SpammerThread starting.");
            ClusterClient client = TestHandler.this.application.getClusterClient();
            if (client != null) {
                while (this.checkPause()) {
                    if (TestHandler.this.getMaximumPause() == 0) {
                        Thread.yield();
                    } else {
                        this.simpleSleep(this.random.nextInt(TestHandler.this.getMaximumPause() - TestHandler.this.getMinimumPause()) + TestHandler.this.getMinimumPause());
                    }
                    TestBroadcast message = new TestBroadcast();
                    if (TestHandler.this.getMaximumPause() > 20) {
                        TestHandler.this.log.log("Sending " + message);
                    }
                    client.send(message);
                }
            } else {
                TestHandler.this.log.log("No ClusterClient available from application.");
            }
        }
    }
}

