/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.server;

import com.techempower.gemini.cluster.server.ConfigurationException;
import com.techempower.gemini.cluster.server.Master;
import com.techempower.util.EnhancedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class MasterUtilities {
    public static EnhancedProperties readConfigurationFile(File file) throws ConfigurationException {
        EnhancedProperties toReturn = new EnhancedProperties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                toReturn.load(fis);
                return toReturn;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioexc) {
            throw new ConfigurationException("Could not read configuration file " + file.getAbsolutePath(), ioexc);
        }
    }

    public static void writePropertiesFile(File file, Properties props) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                props.store(fos, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static EnhancedProperties readPropertiesFile(File file) {
        EnhancedProperties toReturn = new EnhancedProperties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                toReturn.load(fis);
                return toReturn;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return toReturn;
        }
    }

    public static void writeNodeCountFile(File dataDirectory, Master master) {
        File ncf = new File(String.valueOf(dataDirectory.getAbsolutePath()) + File.separator + "nodecount.conf");
        EnhancedProperties props = new EnhancedProperties();
        props.put("HighestNodeID", "" + master.getHighestAssignedNodeId());
        MasterUtilities.writePropertiesFile(ncf, props);
    }

    public static int readNodeCountFile(File dataDirectory) {
        File ncf = new File(String.valueOf(dataDirectory.getAbsolutePath()) + File.separator + "nodecount.conf");
        EnhancedProperties props = MasterUtilities.readPropertiesFile(ncf);
        return props.getIntegerProperty("HighestNodeID", 1000);
    }

    private MasterUtilities() {
    }
}

