/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.server;

public abstract class ServerConnection {
    private int nodeId;
    private int channel;
    private boolean authenticated = false;
    private long messageCount;
    private long connectionTime = System.currentTimeMillis();
    private String description;

    public abstract String getClientName();

    public void setNode(int nodeId) {
        this.nodeId = nodeId;
    }

    public int getNode() {
        return this.nodeId;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public int getChannel() {
        return this.channel;
    }

    public long getConnectionTime() {
        return this.connectionTime;
    }

    public long getConnectionUptime() {
        return System.currentTimeMillis() - this.getConnectionTime();
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public long incrementMessageCount() {
        return ++this.messageCount;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public String getClientDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "Connection [" + this.getNode() + "; " + this.getClientName() + "]";
    }
}

