/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.server.handler;

import com.techempower.TechEmpowerApplication;
import com.techempower.collection.relation.IntegerRelation;
import com.techempower.collection.relation.ManyToManyIntegerRelation;
import com.techempower.gemini.cluster.message.CacheMessage;
import com.techempower.gemini.cluster.server.ClusterHandler;
import com.techempower.gemini.cluster.server.Master;
import com.techempower.gemini.cluster.server.ServerConnection;
import com.techempower.util.EnhancedProperties;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

public class CacheMessageHandler
implements ClusterHandler<CacheMessage> {
    public static final long DEFAULT_UPDATE_CONLICT_WINDOW = 5000L;
    private final TIntObjectMap<IntegerRelation>[] updateMaps = new TIntObjectMap[]{new TIntObjectHashMap(), new TIntObjectHashMap()};
    private final long[] lastUpdateTimes = new long[2];
    private int updateIndex = 0;
    private long lastUpdateCycle = 0L;
    private long updateConflictWindow = 5000L;

    public CacheMessageHandler(TechEmpowerApplication application) {
    }

    @Override
    public Class<CacheMessage> getMessageClass() {
        return CacheMessage.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(ServerConnection client, CacheMessage request, Master master) {
        if (request.getAction() == 0) {
            CacheMessageHandler cacheMessageHandler = this;
            synchronized (cacheMessageHandler) {
                int groupId = request.getGroupId();
                int objectId = request.getObjectId();
                long now = System.currentTimeMillis();
                if (now - this.lastUpdateCycle > this.updateConflictWindow) {
                    this.updateIndex = (this.updateIndex + 1) % 2;
                    TIntObjectIterator iter = this.updateMaps[this.updateIndex].iterator();
                    while (iter.hasNext()) {
                        iter.advance();
                        ((IntegerRelation)iter.value()).clear();
                    }
                    this.lastUpdateCycle = now;
                }
                this.lastUpdateTimes[this.updateIndex] = now;
                IntegerRelation objectsAndNodes = (IntegerRelation)this.updateMaps[this.updateIndex].get(groupId);
                if (objectsAndNodes == null) {
                    objectsAndNodes = new ManyToManyIntegerRelation();
                    this.updateMaps[this.updateIndex].put(groupId, (Object)objectsAndNodes);
                }
                objectsAndNodes.add(objectId, client.getNode());
                int i = 0;
                while (i < this.updateMaps.length) {
                    IntegerRelation ir;
                    if (now - this.lastUpdateTimes[i] <= this.updateConflictWindow && (ir = (IntegerRelation)this.updateMaps[i].get(groupId)) != null && ir.rightSize(objectId) > 1) {
                        CacheMessage message = new CacheMessage();
                        message.setAction(0);
                        message.setGroupId(groupId);
                        message.setObjectId(objectId);
                        master.send(message);
                        return;
                    }
                    ++i;
                }
            }
        }
        master.send(client, request);
    }

    @Override
    public void configure(EnhancedProperties props) {
        String propsPrefix = "CacheMessageHandler.";
        this.updateConflictWindow = props.getLongProperty(String.valueOf(propsPrefix) + "UpdateConflictWindow", this.updateConflictWindow);
    }

    @Override
    public boolean requiresAuthentication() {
        return true;
    }

    @Override
    public boolean requiresSeparateThread() {
        return false;
    }
}

