/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.cluster.server.handler;

import com.techempower.TechEmpowerApplication;
import com.techempower.gemini.cluster.message.ConfigurationRequest;
import com.techempower.gemini.cluster.message.ConfigurationResponse;
import com.techempower.gemini.cluster.server.ClusterHandler;
import com.techempower.gemini.cluster.server.ConfigurationException;
import com.techempower.gemini.cluster.server.Master;
import com.techempower.gemini.cluster.server.MasterUtilities;
import com.techempower.gemini.cluster.server.ServerConnection;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationHandler
implements ClusterHandler<ConfigurationRequest> {
    private final TechEmpowerApplication application;
    private final ComponentLog log;
    private final Map<String, EnhancedProperties> nodeProperties = new HashMap<String, EnhancedProperties>();
    private EnhancedProperties template;

    public ConfigurationHandler(TechEmpowerApplication application) {
        this.application = application;
        this.log = application.getLog("cHcf");
    }

    @Override
    public Class<ConfigurationRequest> getMessageClass() {
        return ConfigurationRequest.class;
    }

    @Override
    public void handle(ServerConnection client, ConfigurationRequest request, Master master) {
        EnhancedProperties config = this.generateConfiguration(client, request);
        client.setDescription(config.getProperty("DeploymentDescription"));
        ConfigurationResponse response = new ConfigurationResponse();
        response.setProperties(config);
        master.sendResponse(client, request, response);
    }

    @Override
    public boolean requiresAuthentication() {
        return true;
    }

    @Override
    public void configure(EnhancedProperties props) {
        String templateFilename = props.getProperty("ConfigurationHandler.Template");
        if (StringHelper.isNonEmpty(templateFilename)) {
            File file = new File(templateFilename);
            if (file.exists()) {
                try {
                    File confFile = new File(templateFilename);
                    EnhancedProperties templateContents = MasterUtilities.readConfigurationFile(confFile);
                    this.loadExtendedProperties(confFile, templateContents);
                    this.log.log("Loaded template " + templateFilename);
                    this.template = templateContents;
                }
                catch (ConfigurationException cfexc) {
                    this.log.log("Exception while reading template configuration file (" + templateFilename + "):" + cfexc);
                }
            } else {
                this.log.log("Configuration template file " + templateFilename + " does not exist.");
            }
        }
        EnhancedProperties nodes = props.extractProperties("ConfigurationHandler.Node", false);
        Enumeration<Object> keys = nodes.keys();
        while (keys.hasMoreElements()) {
            try {
                String filename;
                String ip;
                String key = (String)keys.nextElement();
                int node = NumberHelper.parseInt(key.substring(25, key.indexOf(46, 25)));
                if (node <= 0 || this.nodeProperties.get(ip = props.getProperty("ConfigurationHandler.Node" + node + ".IP")) != null || (filename = props.getProperty("ConfigurationHandler.Node" + node + ".File")) == null) continue;
                File confFile = new File(filename);
                EnhancedProperties nodeProps = MasterUtilities.readConfigurationFile(confFile);
                this.loadExtendedProperties(confFile, nodeProps);
                if (nodeProps.size() <= 0) continue;
                this.nodeProperties.put(ip, nodeProps);
                this.log.log("Loaded for " + ip + ": " + filename);
            }
            catch (Exception exc) {
                this.log.log("Exception while reading node configuration: " + exc);
            }
        }
    }

    protected void loadExtendedProperties(File sourceFile, EnhancedProperties props) throws ConfigurationException {
        String extendedFilename = props.getProperty("Extends");
        if (extendedFilename != null) {
            String directory = sourceFile.getParent();
            File extendedFile = new File(String.valueOf(directory) + File.separator + extendedFilename);
            EnhancedProperties extendedProps = MasterUtilities.readConfigurationFile(extendedFile);
            this.loadExtendedProperties(extendedFile, extendedProps);
            extendedProps.putAll((Map<?, ?>)props);
            props.clear();
            props.putAll((Map<?, ?>)extendedProps);
        }
    }

    protected EnhancedProperties getTemplate() {
        return this.template;
    }

    protected EnhancedProperties generateConfiguration(ServerConnection client, ConfigurationRequest request) {
        EnhancedProperties props = this.nodeProperties.get(client.getClientName());
        if (props == null && this.getTemplate() != null) {
            props = new EnhancedProperties(this.application);
            props.putAll((Map<?, ?>)this.getTemplate());
        }
        if (props != null) {
            this.preprocessing(props, client, request);
            this.customProcessing(props, client, request);
            return props;
        }
        this.log.log("Configuration request received; no template available!", 70);
        return new EnhancedProperties(this.application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preprocessing(EnhancedProperties props, ServerConnection client, ConfigurationRequest request) {
        props.setProperty("Servlet.MachineName", request.machineName);
        String descriptor = props.getProperty("DeploymentDescription");
        ConfigurationHandler configurationHandler = this;
        synchronized (configurationHandler) {
            descriptor = StringHelper.isEmpty(descriptor) ? "Spawned instance #" + client.getNode() : String.valueOf(descriptor) + " (Spawned instance #" + client.getNode() + ")";
        }
        props.put("SpawnedInstance", "" + client.getNode());
        props.put("DeploymentDescription", descriptor);
    }

    public void customProcessing(EnhancedProperties props, ServerConnection client, ConfigurationRequest request) {
    }

    @Override
    public boolean requiresSeparateThread() {
        return false;
    }
}

