/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.configuration;

import com.techempower.gemini.Configurator;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.configuration.ConfigurationProvider;
import com.techempower.log.ComponentLog;
import com.techempower.util.EnhancedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;

public class FileConfigurationProvider
implements ConfigurationProvider {
    @Override
    public boolean load(GeminiApplication application, ComponentLog log, EnhancedProperties props) {
        try {
            String filenames = this.getConfigFilenames(application, log);
            StringTokenizer tokenizer = new StringTokenizer(filenames, ",");
            while (tokenizer.hasMoreTokens()) {
                String filename = tokenizer.nextToken().trim();
                this.loadPropertiesFromFile(application, log, props, filename);
            }
            this.loadExtendedProperties(application, log, props);
            return props.size() > 0;
        }
        catch (IOException ioexc) {
            log.log("IOException while loading configuration files: " + ioexc);
            return false;
        }
    }

    protected void loadPropertiesFromFile(GeminiApplication application, ComponentLog log, EnhancedProperties props, String filename) throws IOException {
        FileInputStream is;
        Object var8_14;
        File file;
        InputStream is2;
        Throwable throwable;
        Throwable throwable2;
        boolean loaded = false;
        if (!loaded) {
            throwable2 = null;
            throwable = null;
            try {
                is2 = this.getClass().getClassLoader().getResourceAsStream(filename);
                try {
                    if (is2 != null) {
                        props.load(is2);
                        loaded = true;
                    }
                }
                finally {
                    if (is2 != null) {
                        is2.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        if (!loaded) {
            throwable2 = null;
            throwable = null;
            try {
                is2 = application.getResourceAsStream(filename);
                try {
                    if (is2 != null) {
                        props.load(is2);
                        loaded = true;
                    }
                }
                finally {
                    if (is2 != null) {
                        is2.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        if (!loaded && (file = new File(filename)).exists()) {
            throwable = null;
            var8_14 = null;
            try {
                is = new FileInputStream(file);
                try {
                    props.load(is);
                    loaded = true;
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        if (!loaded && (file = new File(String.valueOf(new File(".").getCanonicalPath()) + File.separator + filename)).exists()) {
            throwable = null;
            var8_14 = null;
            try {
                is = new FileInputStream(file);
                try {
                    props.load(is);
                    loaded = true;
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        if (loaded) {
            log.log("Read " + filename);
        }
    }

    protected void loadExtendedProperties(GeminiApplication application, ComponentLog log, EnhancedProperties props) throws IOException {
        String[] stringArray = props.getArrayProperty("Extends");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String extendedFilename = stringArray[n2];
            EnhancedProperties extendedProps = new EnhancedProperties(application);
            this.loadPropertiesFromFile(application, log, extendedProps, extendedFilename);
            this.loadExtendedProperties(application, log, extendedProps);
            extendedProps.putAll((Map<?, ?>)props);
            props.clear();
            props.putAll((Map<?, ?>)extendedProps);
            ++n2;
        }
    }

    protected String getConfigFilenames(GeminiApplication application, ComponentLog log) {
        String filenames;
        if (application.getServletConfigParameter("ConfigurationFile") != null) {
            filenames = application.getServletConfigParameter("ConfigurationFile");
            log.log("Using specified configuration file(s): " + filenames);
        } else if (System.getProperty("ConfigurationFile") != null) {
            filenames = System.getProperty("ConfigurationFile");
            log.log("Using specified configuration file(s): " + filenames);
        } else {
            String abbrName = application.getVersion().getAbbreviatedProductName();
            String machineName = Configurator.getMachineName();
            filenames = String.valueOf(abbrName) + ".conf" + "," + abbrName + "-" + machineName + ".conf";
            log.log("Using default configuration file(s): " + filenames);
        }
        return filenames;
    }
}

