/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.context;

import com.techempower.gemini.Context;
import com.techempower.gemini.context.SessionNamedValues;
import com.techempower.gemini.messaging.Message;
import com.techempower.gemini.messaging.MessageType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Messages {
    private static final String SO_MESSAGE_QUEUE = "_message_queue";
    private static final List<Message> EMPTY_MESSAGES = Collections.unmodifiableList(new ArrayList(0));
    private final SessionNamedValues session;

    public Messages(Context context) {
        this.session = context.session();
    }

    public Messages put(Message message) {
        if (message != null) {
            LinkedList<Message> messages = (LinkedList<Message>)this.session.getObject(SO_MESSAGE_QUEUE);
            if (messages == null) {
                messages = new LinkedList<Message>();
                this.session.putObject(SO_MESSAGE_QUEUE, messages);
            }
            messages.add(message);
        }
        return this;
    }

    public Messages normal(String message) {
        return this.put(message, MessageType.NORMAL);
    }

    public Messages warning(String message) {
        return this.put(message, MessageType.WARNING);
    }

    public Messages success(String message) {
        return this.put(message, MessageType.SUCCESS);
    }

    public Messages error(String message) {
        return this.put(message, MessageType.ERROR);
    }

    public Messages put(String message, MessageType type) {
        if (message != null) {
            Message m = type == null ? new Message(message) : new Message(message, type);
            this.put(m);
        }
        return this;
    }

    public List<Message> queue() {
        return (List)this.session.getObject(SO_MESSAGE_QUEUE);
    }

    public List<Message> list() {
        List<Message> queue = this.queue();
        if (queue != null) {
            ArrayList<Message> messages = new ArrayList<Message>(queue);
            queue.clear();
            return messages;
        }
        return EMPTY_MESSAGES;
    }

    public List<Message> listFiltered(MessageType ... type) {
        List<MessageType> types = Arrays.asList(type);
        ArrayList<Message> messages = new ArrayList<Message>();
        List<Message> queue = this.queue();
        if (queue != null) {
            ListIterator<Message> iterator = queue.listIterator();
            while (iterator.hasNext()) {
                Message m = iterator.next();
                if (!types.contains((Object)m.getType())) continue;
                iterator.remove();
                messages.add(m);
            }
        }
        return messages;
    }

    public List<Message> listErrors() {
        return this.listFiltered(MessageType.ERROR);
    }

    public List<Message> listNormal() {
        return this.listFiltered(MessageType.NORMAL);
    }

    public List<Message> listWarning() {
        return this.listFiltered(MessageType.WARNING);
    }

    public List<Message> listSuccess() {
        return this.listFiltered(MessageType.SUCCESS);
    }
}

