/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.context;

import com.techempower.collection.ImmutableNamedValues;
import com.techempower.gemini.Request;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class Query
implements ImmutableNamedValues {
    private final Request request;

    public Query(Request request) {
        this.request = request;
    }

    @Override
    public boolean has(String name) {
        return this.request.getParameter(name) != null;
    }

    @Override
    public Set<String> names() {
        Enumeration<String> parameterNames = this.request.getParameterNames();
        HashSet<String> names = new HashSet<String>();
        while (parameterNames.hasMoreElements()) {
            names.add(parameterNames.nextElement());
        }
        return names;
    }

    @Override
    public String get(String name) {
        return this.get(name, null);
    }

    @Override
    public String get(String name, String defaultValue) {
        String value = this.request.getParameter(name);
        return value != null ? value : defaultValue;
    }

    public String[] getStrings(String name) {
        return this.request.getParameterValues(name);
    }

    public int[] getInts(String name) {
        String[] values = this.getStrings(name);
        return values != null ? CollectionHelper.toIntArray(values) : null;
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        return NumberHelper.parseInt(this.get(name), defaultValue);
    }

    @Override
    public int getInt(String name, int defaultValue, int minimum, int maximum) {
        return NumberHelper.boundInteger(this.getInt(name, defaultValue), minimum, maximum);
    }

    @Override
    public long getLong(String name, long defaultValue, long minimum, long maximum) {
        return NumberHelper.boundLong(this.getLong(name, defaultValue), minimum, maximum);
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        return NumberHelper.parseLong(this.get(name), defaultValue);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.request.getParameter(name);
        if (defaultValue) {
            return !"false".equals(value);
        }
        return "true".equals(value);
    }

    public boolean getBooleanLenient(String name, boolean defaultValue) {
        String value = this.request.getParameter(name);
        return StringHelper.parseBoolean(value, defaultValue);
    }

    public <O extends Enum<O>> O getEnum(String name, Class<O> type) {
        return this.getEnum(name, type, null);
    }

    public <O extends Enum<O>> O getEnum(String name, Class<O> type, O defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(type, value);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String name, double defaultValue) {
        double value = defaultValue;
        try {
            value = Double.parseDouble(this.request.getParameter(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

