/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.data;

import com.techempower.gemini.data.SqlQueue;
import com.techempower.helper.DateHelper;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;
import java.util.Calendar;

public class SqlQueueEvent
extends ScheduledEvent {
    private final SqlQueue queue;
    private final int interval;

    public SqlQueueEvent(SqlQueue queue, int interval) {
        this.queue = queue;
        this.interval = interval;
    }

    @Override
    public long getDefaultScheduledTime() {
        Calendar scheduledTime = DateHelper.getCalendarInstance();
        scheduledTime.add(12, this.interval);
        return scheduledTime.getTimeInMillis();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean requiresOwnThread() {
        return true;
    }

    @Override
    public void execute(Scheduler scheduler) {
        try {
            this.queue.flush();
        }
        finally {
            this.reschedule(scheduler, 12, this.interval);
        }
    }
}

