/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.email;

import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.email.EmailAttachment;
import com.techempower.gemini.email.EmailAuthenticator;
import com.techempower.gemini.email.EmailHeader;
import com.techempower.helper.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EmailPackage {
    public static final String JAVAX_MAIL_MESSAGE = "javax.mail.Message";
    private String recipientAddress = "";
    private String recipientSource = "";
    private String mailServer = null;
    private String messageBody = "";
    private String htmlMessageBody = "";
    private String authorAddress = "";
    private String bccRecipientAddress = "";
    private String subject = "";
    private String charset = "";
    private List<EmailAttachment> attachments = null;
    private Map<String, Object> custom = null;
    private Collection<EmailHeader> headers = null;
    private boolean sent = false;
    private boolean successful = false;
    private boolean hasHtmlBody = false;
    private boolean hasTextBody = false;
    private EmailAuthenticator authenticator = null;
    private int deliveryAttempts = 0;

    public EmailPackage(String subject, String plainBody, String htmlBody, String recipient, String author) {
        this.setTextBody(plainBody);
        this.setHtmlBody(htmlBody);
        this.setSubject(subject);
        this.setRecipient(recipient);
        this.setAuthor(author);
        this.setHtmlEnabled(true);
    }

    public EmailPackage(String subject, String messageBody, String recipient, String author) {
        this.setTextBody(messageBody);
        this.setSubject(subject);
        this.setRecipient(recipient);
        this.setAuthor(author);
    }

    public EmailPackage(String subject, String messageBody) {
        this.setTextBody(messageBody);
        this.setSubject(subject);
    }

    public EmailPackage(String recipient) {
        this.setRecipient(recipient);
    }

    public void setCustomAttribute(String customAttributeName, Object value) {
        if (this.custom == null) {
            this.custom = new HashMap<String, Object>();
        }
        this.custom.put(customAttributeName, value);
    }

    public String getCustomAttribute(String customAttributeName) {
        String value;
        if (this.custom != null && (value = (String)this.custom.get(customAttributeName)) != null) {
            return value;
        }
        return "";
    }

    public Object getCustomAttributeObject(String customAttributeName) {
        if (this.custom != null) {
            return this.custom.get(customAttributeName);
        }
        return null;
    }

    public Collection<EmailHeader> getHeaders() {
        return this.headers;
    }

    public EmailHeader getHeader(String headerName) {
        if (this.headers != null) {
            for (EmailHeader emailHeader : this.headers) {
                if (!emailHeader.getHeaderName().equals(headerName)) continue;
                return emailHeader;
            }
        }
        return null;
    }

    public void setHeaders(Collection<EmailHeader> headers) {
        this.headers = headers;
    }

    public void addHeader(EmailHeader header) {
        if (this.headers == null) {
            this.headers = new ArrayList<EmailHeader>();
        }
        this.headers.add(header);
    }

    public void removeHeader(String headerName) {
        if (this.headers != null) {
            Iterator<EmailHeader> it = this.headers.iterator();
            while (it.hasNext()) {
                EmailHeader header = it.next();
                if (!header.getHeaderName().equals(headerName)) continue;
                it.remove();
            }
        }
    }

    public void setSent(boolean sent) {
        this.sent = sent;
    }

    public boolean wasSent() {
        return this.sent;
    }

    public void setSuccessful(boolean success) {
        this.successful = success;
    }

    public boolean wasSuccessful() {
        return this.successful;
    }

    public void incrementDeliveryAttempts() {
        ++this.deliveryAttempts;
    }

    public void resetDeliveryAttempts() {
        this.deliveryAttempts = 0;
    }

    public int getDeliveryAttempts() {
        return this.deliveryAttempts;
    }

    public void setRecipient(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public String getRecipientSource() {
        return this.recipientSource;
    }

    public void setRecipientSource(String recipientSource) {
        this.recipientSource = recipientSource;
    }

    public String getRecipient() {
        return this.recipientAddress;
    }

    public void setAuthor(String authorAddress) {
        this.authorAddress = authorAddress;
    }

    public String getAuthor() {
        return this.authorAddress;
    }

    public void setBccRecipient(String bccRecipientAddress) {
        this.bccRecipientAddress = bccRecipientAddress;
    }

    public String getBccRecipient() {
        return this.bccRecipientAddress;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean hasAttachments() {
        return this.attachments != null && !this.attachments.isEmpty();
    }

    public void setTextBody(String messageBody) {
        this.messageBody = messageBody;
        this.setTextEnabled(messageBody != null);
    }

    public String getTextBody() {
        return this.messageBody;
    }

    public void setHtmlBody(String messageBody) {
        this.htmlMessageBody = messageBody;
        this.setHtmlEnabled(messageBody != null);
    }

    public String getHtmlBody() {
        String tempTextBody = GeminiHelper.convertHtmlToText(this.htmlMessageBody).trim();
        if (tempTextBody == null || tempTextBody.length() == 0) {
            return this.getTextBody();
        }
        return this.htmlMessageBody;
    }

    public void addAttachment(EmailAttachment attachment) {
        if (attachment != null) {
            if (this.attachments == null) {
                this.attachments = new ArrayList<EmailAttachment>();
            }
            this.attachments.add(attachment);
        }
    }

    public void setAttachments(Collection<EmailAttachment> pAttachments) {
        if (this.attachments != null) {
            Iterator<EmailAttachment> iter = pAttachments.iterator();
            while (iter.hasNext()) {
                this.attachments.add(iter.next());
            }
        } else {
            this.attachments = new ArrayList<EmailAttachment>(pAttachments);
        }
    }

    public Collection<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public void setMailServer(String mailServer) {
        this.mailServer = mailServer;
    }

    public String getMailServer() {
        return this.mailServer;
    }

    public EmailAuthenticator getEmailAuthenticator() {
        return this.authenticator;
    }

    public void setEmailAuthenticator(EmailAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setHtmlEnabled(boolean htmlFlag) {
        this.hasHtmlBody = htmlFlag;
    }

    public boolean isHtmlEnabled() {
        return this.hasHtmlBody;
    }

    public void setTextEnabled(boolean htmlFlag) {
        this.hasTextBody = htmlFlag;
    }

    public boolean isTextEnabled() {
        return this.hasTextBody;
    }

    public String toString() {
        return "EmailPackage [f:" + this.getAuthor() + "; t:" + this.getRecipient() + "; s:" + StringHelper.truncateEllipsis(this.getSubject(), 20) + "]";
    }
}

