/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.email;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.email.EmailAttachment;
import com.techempower.gemini.email.EmailAuthenticator;
import com.techempower.gemini.email.EmailHandler;
import com.techempower.gemini.email.EmailHeader;
import com.techempower.gemini.email.EmailPackage;
import com.techempower.gemini.email.EmailServerDescriptor;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailTransport
implements Configurable {
    public static final String COMPONENT_CODE = "emxp";
    public static final String DEFAULT_SERVER_ADDRESS = "mail";
    public static final String MULTIPLE_SERVER_PREFIX = "MailServer";
    public static final int DEFAULT_SMTP_PORT = 25;
    public static final int DEFAULT_POP_PORT = 110;
    public static final int DEFAULT_PROTO_INIT_TIMEOUT = 100;
    public static final int DEFAULT_SOCKET_TIMEOUT = 100;
    public static final int DEFAULT_RETRIES = 10;
    private final ComponentLog log;
    private int maximumRetries = 10;
    private EmailServerDescriptor[] mailServers = new EmailServerDescriptor[0];
    private EmailServerDescriptor[] outboundServers = new EmailServerDescriptor[0];
    private EmailServerDescriptor[] inboundServers = new EmailServerDescriptor[0];
    private final Object lockObject = new Object();
    private boolean outboundMailEnabled = true;
    private Collection<String> deliveryDomains = null;
    private String defaultUsername = null;
    private String defaultPassword = null;
    private Authenticator defaultAuthenticator = null;

    public EmailTransport(GeminiApplication application) {
        this.log = application.getLog(COMPONENT_CODE);
        application.getConfigurator().addConfigurable(this);
    }

    public String getApplicationPrefix() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(EnhancedProperties props) {
        this.maximumRetries = props.getIntegerProperty(String.valueOf(this.getApplicationPrefix()) + "MailDeliveryRetries", this.maximumRetries);
        this.outboundMailEnabled = props.getYesNoProperty(String.valueOf(this.getApplicationPrefix()) + "MailServerEnabled", this.outboundMailEnabled);
        this.outboundMailEnabled = props.getYesNoProperty(String.valueOf(this.getApplicationPrefix()) + "OutboundMailEnabled", this.outboundMailEnabled);
        if (!this.outboundMailEnabled) {
            this.log.log("Outbound email disabled.  Server definitions are still processed to permit inbound email as needed.");
        }
        String domains = props.getProperty(String.valueOf(this.getApplicationPrefix()) + "DeliveryDomains", "");
        domains = props.getProperty(String.valueOf(this.getApplicationPrefix()) + "MailDeliveryDomains", domains);
        this.defaultUsername = props.getProperty(String.valueOf(this.getApplicationPrefix()) + "SmtpUsername", this.defaultUsername);
        this.defaultPassword = props.getProperty(String.valueOf(this.getApplicationPrefix()) + "SmtpPassword", this.defaultPassword);
        this.defaultUsername = props.getProperty(String.valueOf(this.getApplicationPrefix()) + "MailDefaultUsername", this.defaultUsername);
        this.defaultPassword = props.getProperty(String.valueOf(this.getApplicationPrefix()) + "MailDefaultPassword", this.defaultPassword);
        Object object = this.lockObject;
        synchronized (object) {
            this.defaultAuthenticator = StringHelper.isNonEmpty(this.defaultUsername) ? new EmailAuthenticator(this.defaultUsername, this.defaultPassword) : null;
            StringTokenizer domainTokenizer = new StringTokenizer(domains, ",");
            this.deliveryDomains = null;
            while (domainTokenizer.hasMoreTokens()) {
                String domain = domainTokenizer.nextToken();
                if (this.deliveryDomains == null) {
                    this.deliveryDomains = new ArrayList<String>(2);
                }
                this.deliveryDomains.add(domain);
                if (!this.outboundMailEnabled) continue;
                this.log.log("Email permitted to domain " + domain);
            }
            int serverCount = this.countMailServerDefinitions(props);
            this.mailServers = new EmailServerDescriptor[serverCount];
            int i = 0;
            while (i < serverCount) {
                EnhancedProperties.Focus focus = props.focus(String.valueOf(this.getApplicationPrefix()) + MULTIPLE_SERVER_PREFIX + (i + 1) + ".");
                this.mailServers[i] = new EmailServerDescriptor(focus);
                ++i;
            }
            this.deriveServerReferenceCaches(this.mailServers);
            this.log.log(String.valueOf(serverCount) + " mail server" + StringHelper.pluralize(serverCount) + " specified, shown below.");
            i = 0;
            while (i < serverCount) {
                this.log.log(String.valueOf(i + 1) + " - " + this.mailServers[i]);
                ++i;
            }
        }
    }

    protected void deriveServerReferenceCaches(EmailServerDescriptor[] servers) {
        int countIn = 0;
        int countOut = 0;
        int i = 0;
        while (i < servers.length) {
            if (servers[i].isInbound()) {
                ++countIn;
            }
            if (servers[i].isOutbound()) {
                ++countOut;
            }
            ++i;
        }
        EmailServerDescriptor[] inbound = new EmailServerDescriptor[countIn];
        EmailServerDescriptor[] outbound = new EmailServerDescriptor[countOut];
        countIn = 0;
        countOut = 0;
        int i2 = 0;
        while (i2 < servers.length) {
            if (servers[i2].isInbound()) {
                inbound[countIn++] = servers[i2];
            }
            if (servers[i2].isOutbound()) {
                outbound[countOut++] = servers[i2];
            }
            ++i2;
        }
        this.inboundServers = inbound;
        this.outboundServers = outbound;
    }

    public int countMailServerDefinitions(EnhancedProperties props) {
        int count = 0;
        String serverName = "";
        while (count == 0 || props.isDefined(serverName)) {
            serverName = String.valueOf(this.getApplicationPrefix()) + MULTIPLE_SERVER_PREFIX + ++count + ".ServerAddress";
        }
        return count - 1;
    }

    /*
     * Unable to fully structure code
     */
    public boolean sendEmail(EmailPackage email) {
        block47: {
            block48: {
                if (!this.outboundMailEnabled) {
                    this.log.log("Outbound email disabled.");
                    return true;
                }
                if (email == null) break block48;
                charsetString = "";
                if (StringHelper.isNonEmpty(email.getCharset())) {
                    charsetString = "; charset=" + email.getCharset();
                }
                if (this.deliveryDomains != null) {
                    permitted = false;
                    for (String domain : this.deliveryDomains) {
                        if (email.getRecipient() == null || !email.getRecipient().toLowerCase().endsWith(domain)) continue;
                        permitted = true;
                        break;
                    }
                    if (!permitted) {
                        this.log.log("Mail not permitted to " + email.getRecipient());
                        return true;
                    }
                }
                tryNumber = email.getDeliveryAttempts();
                mailSession = null;
                if (email.getMailServer() != null) ** GOTO lbl26
                servers = this.getOutboundServers();
                if (servers.length > 0) {
                    mailSession = servers[tryNumber % servers.length].getSession();
                } else {
                    this.log.log("Mail failed to send because there are no servers defined.");
                    return false;
lbl26:
                    // 1 sources

                    if (StringHelper.isNonEmpty(email.getRecipientSource())) {
                        var8_6 = this.getOutboundServers();
                        var7_7 = var8_6.length;
                        var6_12 = 0;
                        while (var6_12 < var7_7) {
                            descriptor = var8_6[var6_12];
                            if (descriptor.getServerAddress().equalsIgnoreCase(email.getMailServer()) && email.getRecipientSource().equalsIgnoreCase(descriptor.getProperties().getProperty("mail.smtp.recipientsource"))) {
                                mailSession = descriptor.getSession();
                                break;
                            }
                            ++var6_12;
                        }
                    }
                    if (mailSession == null) {
                        var8_6 = this.getOutboundServers();
                        var7_7 = var8_6.length;
                        var6_12 = 0;
                        while (var6_12 < var7_7) {
                            descriptor = var8_6[var6_12];
                            if (descriptor.getServerAddress().equalsIgnoreCase(email.getMailServer()) && StringHelper.isEmpty(descriptor.getProperties().getProperty("mail.smtp.recipientsource"))) {
                                mailSession = descriptor.getSession();
                                break;
                            }
                            ++var6_12;
                        }
                    }
                    if (mailSession == null) {
                        props = new Properties();
                        props.put("mail.smtp.host", email.getMailServer());
                        props.put("mail.smtp.connectiontimeout", "100000");
                        props.put("mail.smtp.timeout", "100000");
                        if (this.defaultAuthenticator != null || email.getEmailAuthenticator() != null) {
                            props.put("mail.smtp.auth", "true");
                        }
                        mailSession = email.getEmailAuthenticator() != null ? Session.getInstance((Properties)props, (Authenticator)email.getEmailAuthenticator()) : Session.getInstance((Properties)props, (Authenticator)this.defaultAuthenticator);
                    }
                }
                message = null;
                alternativeEmail = email.isTextEnabled() != false && email.isHtmlEnabled() != false;
                try {
                    message = new MimeMessage(mailSession);
                    message.addFrom((Address[])InternetAddress.parse((String)email.getAuthor(), (boolean)false));
                    message.setReplyTo((Address[])InternetAddress.parse((String)email.getAuthor(), (boolean)false));
                    message.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)email.getRecipient(), (boolean)false));
                    if (StringHelper.isNonEmpty(email.getBccRecipient())) {
                        message.addRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)email.getBccRecipient(), (boolean)false));
                    }
                    message.setSubject(email.getSubject(), email.getCharset());
                    if (email.getHeaders() != null && !email.getHeaders().isEmpty()) {
                        for (EmailHeader emailHeader : email.getHeaders()) {
                            message.addHeader(emailHeader.getHeaderName(), emailHeader.getHeaderValue());
                        }
                    } else {
                        message.addHeader("X-Gemini-EBT", email.getRecipient());
                    }
                    if (alternativeEmail || email.hasAttachments()) {
                        if (alternativeEmail) {
                            multipart = new MimeMultipart("alternative");
                            textPart = new MimeBodyPart();
                            textPart.setContent((Object)email.getTextBody(), "text/plain" + charsetString);
                            multipart.addBodyPart((BodyPart)textPart);
                            htmlPart = new MimeBodyPart();
                            htmlPart.setContent((Object)email.getHtmlBody(), "text/html" + charsetString);
                            multipart.addBodyPart((BodyPart)htmlPart);
                        } else {
                            multipart = new MimeMultipart();
                            thePart = new MimeBodyPart();
                            if (email.isHtmlEnabled()) {
                                thePart.setContent((Object)email.getHtmlBody(), "text/html" + charsetString);
                            } else {
                                thePart.setContent((Object)email.getTextBody(), "text/plain" + charsetString);
                            }
                            multipart.addBodyPart((BodyPart)thePart);
                        }
                        if (email.hasAttachments() && alternativeEmail) {
                            mixed = new MimeMultipart("mixed");
                            wrap = new MimeBodyPart();
                            wrap.setContent((Multipart)multipart);
                            mixed.addBodyPart((BodyPart)wrap);
                            attachments = email.getAttachments();
                            iter = attachments.iterator();
                            while (iter.hasNext()) {
                                filePart = new MimeBodyPart();
                                attachment = iter.next();
                                if (attachment.getObjectAttachment() instanceof Message) {
                                    filePart.setContent(attachment.getObjectAttachment(), "message/rfc822");
                                    filePart.setFileName(attachment.getName());
                                } else {
                                    file = attachment.getFile();
                                    dh = new DataHandler((DataSource)new FileDataSource(file));
                                    if (attachment.getName() != null) {
                                        filePart.setFileName(attachment.getName());
                                    } else {
                                        filePart.setFileName(file.getName());
                                    }
                                    filePart.setDataHandler(dh);
                                }
                                mixed.addBodyPart((BodyPart)filePart);
                            }
                            message.setContent((Multipart)mixed);
                        } else if (email.hasAttachments()) {
                            attachments = email.getAttachments();
                            for (EmailAttachment attachment : attachments) {
                                filePart = new MimeBodyPart();
                                if (attachment.getObjectAttachment() instanceof Message) {
                                    filePart.setContent(attachment.getObjectAttachment(), "message/rfc822");
                                    filePart.setFileName(attachment.getName());
                                } else {
                                    file = attachment.getFile();
                                    dh = new DataHandler((DataSource)new FileDataSource(file));
                                    filePart.setFileName(file.getName());
                                    filePart.setDataHandler(dh);
                                }
                                multipart.addBodyPart((BodyPart)filePart);
                            }
                            message.setContent((Multipart)multipart);
                        } else {
                            message.setContent((Multipart)multipart);
                        }
                    } else if (email.isHtmlEnabled()) {
                        message.setContent((Object)email.getTextBody(), "text/html" + charsetString);
                    } else {
                        message.setContent((Object)email.getTextBody(), "text/plain" + charsetString);
                    }
                    try {
                        Transport.send((Message)message);
                        email.setSent(true);
                        return true;
                    }
                    catch (MessagingException exc) {
                        try {
                            email.setSent(false);
                            this.log.log("Exception during JavaMail transport: " + (Object)exc);
                        }
                        catch (MessagingException exc) {
                            email.setSent(false);
                            this.log.log("Exception prior to JavaMail transport:" + (Object)exc);
                        }
                        break block47;
                    }
                }
                finally {
                    message = null;
                }
            }
            this.log.log("Email is null!");
        }
        return false;
    }

    public int checkForMail(EmailServerDescriptor server, EmailHandler handler) {
        int processed = 0;
        Store store = null;
        Folder folder = null;
        try {
            try {
                Session session = server.getSession();
                store = session.getStore("pop3");
                store.connect();
                folder = store.getFolder("INBOX");
                folder.open(2);
                Message[] messages = folder.getMessages();
                if (messages != null && messages.length > 0) {
                    int i = 0;
                    while (i < messages.length) {
                        boolean delete;
                        EmailPackage email = this.convertMessageToEmailPackage(messages[i]);
                        if (email != null) {
                            delete = handler.handleEmail(email);
                            ++processed;
                        } else {
                            delete = true;
                        }
                        if (delete) {
                            messages[i].setFlag(Flags.Flag.DELETED, true);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exc) {
                this.log.log("Exception while checking for mail.", exc);
                try {
                    if (folder != null) {
                        folder.close(true);
                    }
                    if (store != null) {
                        store.close();
                    }
                }
                catch (MessagingException mexc) {
                    this.log.log("Exception while closing store/folder.", mexc);
                }
            }
        }
        finally {
            try {
                if (folder != null) {
                    folder.close(true);
                }
                if (store != null) {
                    store.close();
                }
            }
            catch (MessagingException mexc) {
                this.log.log("Exception while closing store/folder.", mexc);
            }
        }
        return processed;
    }

    protected EmailPackage convertMessageToEmailPackage(Message message) {
        String subject = "";
        StringBuilder messageBody = new StringBuilder();
        StringBuilder messageHtmlBody = new StringBuilder();
        String recipient = "";
        String author = "";
        ArrayList<EmailAttachment> attachments = new ArrayList<EmailAttachment>(2);
        try {
            subject = message.getSubject();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        try {
            recipient = message.getRecipients(Message.RecipientType.TO)[0].toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            author = message.getFrom()[0].toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.processBody(message, messageBody, messageHtmlBody, attachments);
            EmailPackage toReturn = new EmailPackage(subject, messageBody.toString(), messageHtmlBody.toString(), recipient, author);
            if (attachments.size() > 0) {
                toReturn.setAttachments(attachments);
            }
            return toReturn;
        }
        catch (MessagingException exc) {
            this.log.log("MessagingException while processing e-mail.", exc);
        }
        catch (IOException exc) {
            this.log.log("IOException while processing e-mail.", exc);
        }
        return null;
    }

    protected void processBody(Message message, StringBuilder plaintext, StringBuilder html, List<EmailAttachment> attachments) throws MessagingException, IOException {
        String contentType = message.getContentType();
        if (contentType.startsWith("text/plain")) {
            this.log.log("Adding plaintext part.");
            plaintext.append((String)message.getContent());
        } else if (contentType.startsWith("text/html")) {
            this.log.log("Adding html part.");
            html.append((String)message.getContent());
            plaintext.append((String)message.getContent());
        } else if (contentType.startsWith("multipart")) {
            this.log.log("Parsing multipart email.");
            if (message.getContent() instanceof Multipart) {
                Multipart multi = (Multipart)message.getContent();
                this.processMultipart(multi, plaintext, html, attachments);
            } else {
                this.log.log("Content type identified as multipart, but content is not!");
            }
        }
    }

    protected void processMultipart(Multipart multi, StringBuilder plaintext, StringBuilder html, List<EmailAttachment> attachments) throws MessagingException, IOException {
        int partCount = multi.getCount();
        int i = 0;
        while (i < partCount) {
            BodyPart part = multi.getBodyPart(i);
            String partType = part.getContentType();
            String filename = part.getFileName();
            int size = part.getSize();
            this.log.log("Type: " + partType + "; filename: " + filename + "; " + size + " bytes");
            if (partType.startsWith("text/plain")) {
                this.log.log("Adding plaintext part.");
                plaintext.append((String)part.getContent());
            } else if (partType.startsWith("text/html")) {
                this.log.log("Adding HTML part.");
                html.append((String)part.getContent());
            } else if (partType.startsWith("message") && part.getContent() instanceof Message) {
                this.log.log("Recursing embedded message.");
                this.processBody((Message)part.getContent(), plaintext, html, attachments);
            } else if (StringHelper.isNonEmpty(filename)) {
                InputStream is = part.getInputStream();
                this.log.log("Adding attachment part with " + is.available() + " available bytes.");
                EmailAttachment attachment = new EmailAttachment(is, filename);
                attachments.add(attachment);
            } else if (part.getContent() instanceof Multipart) {
                this.log.log("Recursing embedded multipart.");
                this.processMultipart((Multipart)part.getContent(), plaintext, html, attachments);
            } else {
                this.log.log("Unknown part.");
                this.log.log("Content: " + part.getContent());
            }
            ++i;
        }
    }

    public EmailServerDescriptor[] getOutboundServers() {
        return this.outboundServers;
    }

    public EmailServerDescriptor[] getInboundServers() {
        return this.inboundServers;
    }

    public String toString() {
        return "EmailTransport [" + this.mailServers.length + " servers; " + this.hashCode() + "]";
    }

    public int getRetryLimit() {
        return this.maximumRetries;
    }

    public Collection<String> getDeliveryDomains() {
        return this.deliveryDomains;
    }

    public boolean isServerEnabled() {
        return this.outboundMailEnabled;
    }
}

