/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.email.outbound;

import com.techempower.asynchronous.Asynchronous;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.email.EmailPackage;
import com.techempower.gemini.email.EmailTransport;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import com.techempower.helper.ThreadHelper;
import com.techempower.log.ComponentLog;
import com.techempower.thread.PausableThreadPoolExecutor;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class EmailServicer
implements Asynchronous,
Configurable {
    public static final String COMPONENT_CODE = "emsv";
    public static final int DEFAULT_SENDER_THREADS = 10;
    private final ComponentLog log;
    private final EmailTransport transport;
    private final AtomicInteger queued;
    private final AtomicInteger sent;
    private final AtomicInteger removed;
    private volatile PausableThreadPoolExecutor executor;
    private int senderThreads = 10;
    private boolean enabled = true;

    public EmailServicer(GeminiApplication application) {
        this.log = application.getLog(COMPONENT_CODE);
        this.executor = new PausableThreadPoolExecutor(this.senderThreads);
        this.queued = new AtomicInteger();
        this.sent = new AtomicInteger();
        this.removed = new AtomicInteger();
        this.transport = application.getEmailTransport();
        application.addAsynchronous(this);
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.setEnabled(props.getYesNoProperty("OutboundEmailEnabled", this.enabled));
        int newSenderThreads = this.senderThreads;
        if (props.isDefined("OutboundEmailThreads")) {
            newSenderThreads = props.getIntegerProperty("OutboundEmailThreads", this.senderThreads);
        } else if (props.isDefined("EmailerThreads")) {
            newSenderThreads = props.getIntegerProperty("EmailerThreads", this.senderThreads);
        }
        newSenderThreads = NumberHelper.boundInteger(newSenderThreads, 1, Integer.MAX_VALUE);
        if (newSenderThreads != this.senderThreads) {
            this.senderThreads = newSenderThreads;
            final PausableThreadPoolExecutor oldExecutor = this.executor;
            this.executor = new PausableThreadPoolExecutor(newSenderThreads);
            Runnable shutdown = new Runnable(){

                @Override
                public void run() {
                    oldExecutor.shutdown();
                }
            };
            ThreadHelper.schedule(shutdown, 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void begin() {
    }

    @Override
    public void end() {
        this.executor.shutdown();
    }

    protected void incrementQueued() {
        this.queued.incrementAndGet();
    }

    protected void incrementSent() {
        this.sent.incrementAndGet();
    }

    protected void incrementRemoved() {
        this.removed.incrementAndGet();
    }

    public int getRemovedCount() {
        return this.removed.get();
    }

    public int getPendingCount() {
        int currentSent = this.getSentCount();
        int currentQueued = this.getQueuedCount();
        int currentRemoved = this.getRemovedCount();
        return currentQueued - currentSent - currentRemoved;
    }

    public int getQueuedCount() {
        return this.queued.get();
    }

    public int getSentCount() {
        return this.sent.get();
    }

    public int getSenderThreadCount() {
        return this.executor.getActiveCount();
    }

    public int getPeakSenderThreadCount() {
        return this.executor.getLargestPoolSize();
    }

    public int getMaximumSenderThreadCount() {
        return this.senderThreads;
    }

    protected EmailTransport getTransport() {
        return this.transport;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void pause() {
        this.executor.pause();
    }

    public void unpause() {
        this.executor.resume();
    }

    public boolean isPaused() {
        return this.executor.isPaused();
    }

    public boolean sendMail(EmailPackage email) {
        return this.sendMail(email, true);
    }

    protected boolean sendMail(EmailPackage email, boolean incrementQueued) {
        if (this.enabled) {
            if (email == null) {
                this.log.log("Email is null.  Cannot queue.");
                return false;
            }
            if (StringHelper.isNonEmpty(email.getRecipient()) && StringHelper.isNonEmpty(email.getAuthor())) {
                Sender sender = new Sender(this, email);
                this.executor.submit(sender);
                if (incrementQueued) {
                    this.incrementQueued();
                }
                return true;
            }
            this.log.log("Cannot send e-mail with empty author or recipient.");
            return false;
        }
        this.log.log("Email Servicer not enabled.");
        return true;
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    public String toString() {
        String pausedString = "";
        if (this.isPaused()) {
            pausedString = "; Paused";
        }
        int currentSent = this.getSentCount();
        int currentQueued = this.getQueuedCount();
        int currentRemoved = this.getRemovedCount();
        int currentPending = this.getPendingCount();
        return "EmailServicer [" + currentSent + " sent" + "; " + currentQueued + " queued" + "; " + currentRemoved + " removed" + "; " + currentPending + " pending" + pausedString + "]";
    }

    private static class Sender
    implements Runnable {
        private final EmailServicer servicer;
        private final EmailPackage email;

        public Sender(EmailServicer servicer, EmailPackage email) {
            this.servicer = servicer;
            this.email = email;
        }

        @Override
        public void run() {
            boolean success = this.servicer.getTransport().sendEmail(this.email);
            if (success) {
                this.servicer.incrementSent();
            } else {
                this.email.incrementDeliveryAttempts();
                this.log("Mail to " + this.email.getRecipient() + " failed on try " + this.email.getDeliveryAttempts() + ".");
                if (this.email.getDeliveryAttempts() >= this.servicer.getTransport().getRetryLimit()) {
                    this.log("Mail removed from queue.");
                    this.servicer.incrementRemoved();
                } else {
                    this.servicer.sendMail(this.email, false);
                    this.log("Mail requeued.");
                }
            }
        }

        private void log(String debug) {
            this.servicer.getLog().log(debug);
        }
    }
}

