/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.email.outbound;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.email.EmailPackage;
import com.techempower.gemini.email.outbound.EmailTemplater;
import com.techempower.helper.FileHelper;
import com.techempower.helper.StringHelper;
import com.techempower.util.EnhancedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleEmailTemplater
extends EmailTemplater {
    private final ConcurrentHashMap<String, EmailPackage> templates = new ConcurrentHashMap();
    private List<String> templatesToLoad;
    private boolean requireSubject = true;

    public SimpleEmailTemplater(GeminiApplication application) {
        super(application);
    }

    @Override
    public void configure(EnhancedProperties props) {
        super.configure(props);
        this.loadTemplates(props);
    }

    public int loadTemplates(EnhancedProperties props) {
        int loaded = 0;
        if (this.templatesToLoad != null) {
            for (String templateID : this.templatesToLoad) {
                loaded += this.addEmail(props, templateID);
            }
            this.templatesToLoad = null;
        }
        this.getLog().log(String.valueOf(loaded) + " e-mail" + StringHelper.pluralize(loaded) + " loaded.");
        return loaded;
    }

    @Override
    public void addTemplateToLoad(String templateID) {
        if (this.templatesToLoad == null) {
            this.templatesToLoad = new ArrayList<String>();
        }
        this.templatesToLoad.add(templateID);
    }

    @Override
    public EmailPackage process(String templateID, Map<String, Object> macros, String authorAddress, String recipientAddress) {
        EmailPackage emailPkg = this.templates.get(templateID);
        if (emailPkg != null && emailPkg.getTextBody() != null) {
            String messageBody = StringHelper.macroExpand(macros, emailPkg.getTextBody());
            String messageSubj = StringHelper.macroExpand(macros, emailPkg.getSubject());
            EmailPackage newPackage = new EmailPackage(messageSubj, messageBody, recipientAddress, authorAddress);
            if (emailPkg.isHtmlEnabled()) {
                String messageHtmlBody = StringHelper.macroExpand(macros, emailPkg.getHtmlBody());
                newPackage.setHtmlBody(messageHtmlBody);
            }
            return newPackage;
        }
        this.getLog().log("Template not found by ID: " + templateID);
        return null;
    }

    @Override
    public EmailPackage process(String plainBody, String htmlBody, String subject, Map<String, Object> data, String authorAddress, String recipientAddress) {
        String messageBody = StringHelper.macroExpand(data, plainBody);
        String htmlMessageBody = StringHelper.macroExpand(data, htmlBody);
        String messageSubj = StringHelper.macroExpand(data, subject);
        EmailPackage newPackage = new EmailPackage(messageSubj, messageBody, htmlMessageBody, recipientAddress, authorAddress);
        return newPackage;
    }

    @Override
    public EmailPackage process(String body, String subject, Map<String, Object> data, String authorAddress, String recipientAddress) {
        String messageBody = StringHelper.macroExpand(data, body);
        String messageSubj = StringHelper.macroExpand(data, subject);
        EmailPackage newPackage = new EmailPackage(messageSubj, messageBody, recipientAddress, authorAddress);
        return newPackage;
    }

    public int addEmails(EnhancedProperties props, String propertyPrefix) {
        Enumeration<?> propertyNames = props.propertyNames();
        int count = 0;
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            if (!propertyName.startsWith(propertyPrefix)) continue;
            String filename = props.getProperty(propertyName);
            String emailName = propertyName.substring(propertyPrefix.length());
            count += this.addEmail(filename, emailName);
        }
        return count;
    }

    protected int addEmail(EnhancedProperties props, String mailID) {
        String filename = props.getProperty(mailID);
        return this.addEmail(filename, mailID);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int addEmail(String filename, String mailID) {
        if (filename == null) return 0;
        this.getLog().log("Attempting to load " + filename, 10);
        textFile = new File(filename);
        htmlFilename = FileHelper.replaceExtension(filename, "html");
        htmlFile = new File(htmlFilename);
        try {
            var6_6 = null;
            var7_9 = null;
            try {
                textIs = textFile.exists() != false ? new FileInputStream(textFile) : null;
                try {
                    block30: {
                        textReader = textIs != null ? new InputStreamReader(textIs) : null;
                        try {
                            block29: {
                                htmlIs = htmlFile.exists() != false ? new FileInputStream(htmlFile) : null;
                                try {
                                    block28: {
                                        htmlReader = htmlIs != null ? new InputStreamReader(htmlIs) : null;
                                        try {
                                            v0 = this.addEmail(textReader, htmlReader, mailID);
                                            return v0;
                                        }
                                        finally {
                                            if (htmlReader == null) break block28;
                                            htmlReader.close();
                                        }
                                    }
                                    if (htmlIs == null) break block29;
                                }
                                catch (Throwable var7_10) {
                                    if (var6_6 == null) {
                                        var6_6 = var7_10;
                                    } else if (var6_6 != var7_10) {
                                        var6_6.addSuppressed(var7_10);
                                    }
                                    if (htmlIs == null) throw var6_6;
                                    htmlIs.close();
                                    throw var6_6;
                                }
                                htmlIs.close();
                            }
                            if (textReader == null) break block30;
                        }
                        catch (Throwable var7_11) {
                            if (var6_6 == null) {
                                var6_6 = var7_11;
                            } else if (var6_6 != var7_11) {
                                var6_6.addSuppressed(var7_11);
                            }
                            if (textReader == null) throw var6_6;
                            textReader.close();
                            throw var6_6;
                        }
                        textReader.close();
                    }
                    if (textIs != null) {
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var7_12) {
                    if (var6_6 == null) {
                        var6_6 = var7_12;
                    } else if (var6_6 != var7_12) {
                        var6_6.addSuppressed(var7_12);
                    }
                    if (textIs == null) throw var6_6;
                    textIs.close();
                    throw var6_6;
                }
                textIs.close();
lbl-1000:
                // 2 sources

                {
                    return v0;
                }
            }
            catch (Throwable var7_13) {
                if (var6_6 == null) {
                    var6_6 = var7_13;
                    throw var6_6;
                }
                if (var6_6 == var7_13) throw var6_6;
                var6_6.addSuppressed(var7_13);
                throw var6_6;
            }
        }
        catch (IOException ioexc) {
            this.getLog().log("Cannot read email contents for " + mailID + ": " + ioexc);
        }
        return 0;
    }

    protected int addEmail(Reader text, Reader html, String mailID) {
        if (text != null) {
            try {
                LineNumberReader lnReader;
                Throwable throwable;
                block44: {
                    throwable = null;
                    Object var5_7 = null;
                    lnReader = new LineNumberReader(text);
                    String line = lnReader.readLine();
                    if (line != null) {
                        String subject = "";
                        boolean foundSubject = false;
                        if (line.toUpperCase().startsWith("SUBJECT: ")) {
                            foundSubject = true;
                            subject = line.substring(9);
                            line = lnReader.readLine();
                        }
                        if (foundSubject || !this.requireSubject) {
                            StringBuilder messageBody = new StringBuilder(1000);
                            if (line.length() == 0) {
                                line = lnReader.readLine();
                            }
                            while (line != null) {
                                messageBody.append(line);
                                messageBody.append("\r\n");
                                line = lnReader.readLine();
                            }
                            EmailPackage newEmail = new EmailPackage(subject, messageBody.toString());
                            this.templates.put(mailID, newEmail);
                            if (html != null) {
                                Throwable throwable2 = null;
                                Object var13_17 = null;
                                try (LineNumberReader htmlLineReader = new LineNumberReader(html);){
                                    messageBody = new StringBuilder(1000);
                                    line = htmlLineReader.readLine();
                                    while (line != null) {
                                        messageBody.append(line);
                                        messageBody.append("\r\n");
                                        line = htmlLineReader.readLine();
                                    }
                                    newEmail.setHtmlBody(messageBody.toString());
                                    this.getLog().log("Read HTML alternate for " + mailID, 0);
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                        } else {
                            this.getLog().log("E-mail template file for " + mailID + " has no valid subject!", 70);
                        }
                    } else {
                        this.getLog().log("E-mail template file for " + mailID + " has no contents!", 70);
                    }
                    if (lnReader == null) break block44;
                    lnReader.close();
                }
                try {
                    try {
                        text.close();
                        if (html != null) {
                            html.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return 1;
                }
                catch (Throwable throwable4) {
                    try {
                        if (lnReader != null) {
                            lnReader.close();
                        }
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        try {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            throw throwable;
                        }
                        catch (IOException ioexc) {
                            this.getLog().log("Cannot read email contents for " + mailID + ": " + ioexc);
                            try {
                                text.close();
                                if (html != null) {
                                    html.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    text.close();
                    if (html != null) {
                        html.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return 0;
    }

    protected void addEmail(String subject, String text, String mailID) {
        this.templates.put(mailID, new EmailPackage(subject, text));
    }

    public String toString() {
        return "EmailTemplater [" + this.hashCode() + "]";
    }

    public void setRequireSubject(boolean requireSubject) {
        this.requireSubject = requireSubject;
    }
}

