/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.event;

import com.techempower.gemini.GeminiApplication;
import com.techempower.helper.DateHelper;
import com.techempower.log.ComponentLog;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.Calendar;

public class CacheResetEvent
extends ScheduledEvent
implements Configurable {
    public static final String LOCAL_COMPONENT_CODE1 = "eRST";
    public static final String PROPS_PREFIX = "CacheReset.";
    public static final String PROPS_INTERVAL = "IntervalHours";
    public static final String PROPS_ENABLED = "Enabled";
    public static final String PROPS_NOTIFY = "NotifyPeers";
    public static final int DEFAULT_INTERVAL = 24;
    private int interval = 24;
    private boolean notifyListeners = false;
    private final GeminiApplication application;
    private final ComponentLog log;

    public CacheResetEvent(GeminiApplication application) {
        this.application = application;
        this.log = application.getLog(LOCAL_COMPONENT_CODE1);
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.interval = props.getIntegerProperty("CacheReset.IntervalHours", this.interval);
        this.setEnabled(props.getYesNoProperty("CacheReset.Enabled", this.isEnabled()));
        this.notifyListeners = props.getYesNoProperty("CacheReset.NotifyPeers", this.notifyListeners);
        this.application.getScheduler().scheduleEvent(this);
    }

    @Override
    public long getDefaultScheduledTime() {
        Calendar scheduledTime = DateHelper.getCalendarInstance();
        int eventHour = this.interval;
        int currentHour = scheduledTime.get(11);
        if (currentHour >= eventHour) {
            eventHour = this.interval * (currentHour / this.interval + 1);
        }
        scheduledTime.set(11, eventHour);
        scheduledTime.set(12, 0);
        scheduledTime.set(13, 0);
        return scheduledTime.getTimeInMillis();
    }

    @Override
    public void execute(Scheduler scheduler) {
        if (this.isEnabled()) {
            this.doReset();
        }
        scheduler.scheduleEvent((ScheduledEvent)this, this.getNextRunTime());
    }

    public long getNextRunTime() {
        Calendar next = DateHelper.getCalendarInstance();
        next.add(10, this.interval);
        next.set(12, 0);
        next.set(13, 0);
        return next.getTimeInMillis();
    }

    protected void doReset() {
        this.log.log("Performing full cache reset");
        this.application.getStore().reset(this.notifyListeners);
    }

    @Override
    public String getName() {
        return "CacheResetEvent";
    }
}

