/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.event;

import com.techempower.gemini.GeminiApplication;
import com.techempower.helper.DateHelper;
import com.techempower.log.ComponentLog;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.Calendar;

public class NoOpEvent
extends ScheduledEvent
implements Configurable {
    public static final String LOCAL_COMPONENT_CODE = "nevt";
    private final GeminiApplication application;
    private final ComponentLog log;

    public NoOpEvent(GeminiApplication application) {
        this.setName("No operation / Testing");
        this.setDescription("Executes for 30 seconds but does nothing; safe for testing");
        this.application = application;
        this.log = application.getLog(LOCAL_COMPONENT_CODE);
        this.application.getConfigurator().addConfigurable(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
    }

    @Override
    public long getDefaultScheduledTime() {
        Calendar nextRun = DateHelper.getCalendarInstance();
        nextRun.add(11, 1);
        while (nextRun.get(11) != 12) {
            nextRun.add(11, 1);
        }
        nextRun.set(12, 30);
        nextRun.set(13, 0);
        return nextRun.getTimeInMillis();
    }

    @Override
    public boolean requiresOwnThread() {
        return true;
    }

    @Override
    public void execute(Scheduler scheduler, boolean onDemandExecute) {
        try {
            this.doNothing();
        }
        catch (Exception exc) {
            this.log.log("Exception: " + exc);
        }
        this.log.log(this + " complete.");
        if (!onDemandExecute) {
            Calendar newEventTime = DateHelper.getCalendarInstance(this.getScheduledTime());
            newEventTime.add(5, 1);
            scheduler.scheduleEvent((ScheduledEvent)this, newEventTime.getTime());
        }
    }

    public void doNothing() {
        this.log.log("Doing nothing; this is a no-op event.");
    }

    @Override
    public String toString() {
        return "[NoOpEvent: " + this.getScheduledTime() + "]";
    }
}

