/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.exceptionhandler;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.GeminiHelper;
import com.techempower.gemini.exceptionhandler.ExceptionHandler;
import com.techempower.gemini.feature.Feature;
import com.techempower.gemini.feature.FeatureManager;
import com.techempower.helper.StringHelper;
import com.techempower.helper.ThrowableHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.HashMap;
import javax.servlet.ServletException;

public class BasicExceptionHandler
implements ExceptionHandler,
Feature,
Configurable {
    public static final String COMPONENT_CODE = "bvEH";
    private final GeminiApplication application;
    private final FeatureManager fm;
    private final ComponentLog log;
    private boolean displayExceptionsInLog = true;
    private boolean displayStackTracesInLog = false;
    private boolean revealStackTrace = true;
    private boolean useErrorCode500 = false;
    private boolean useJson = true;
    private String errorTemplate = null;

    public BasicExceptionHandler(GeminiApplication app) {
        this.application = app;
        this.log = app.getLog(COMPONENT_CODE);
        this.fm = app.getFeatureManager();
        app.getConfigurator().addConfigurable(this);
        this.fm.add("exc-basic", "Basic Exception Handler");
    }

    @Override
    public void configure(EnhancedProperties props) {
        EnhancedProperties.Focus focus = props.focus("BasicExceptionHandler.");
        this.displayExceptionsInLog = focus.getYesNoProperty("LogExceptions", true);
        this.displayStackTracesInLog = focus.getYesNoProperty("LogStackTraces", false);
        this.revealStackTrace = focus.getYesNoProperty("RevealStackTrace", this.revealStackTrace);
        this.useErrorCode500 = focus.getYesNoProperty("UseErrorCode500", this.useErrorCode500);
        this.useJson = focus.getYesNoProperty("UseJson", this.useJson);
        this.errorTemplate = focus.getProperty("ErrorPage", null);
        if (this.errorTemplate != null) {
            this.log.log(String.valueOf(focus.name("ErrorPage")) + " is deprecated; use " + focus.name("ErrorTemplate") + " instead.");
        }
        this.errorTemplate = focus.getProperty("ErrorTemplate", this.errorTemplate);
    }

    public boolean isRevealStackTrace() {
        return this.revealStackTrace;
    }

    public void setRevealStackTrace(boolean revealStackTrace) {
        this.revealStackTrace = revealStackTrace;
    }

    @Override
    public void handleException(Context context, Throwable exc) {
        this.handleException(context, exc, null);
    }

    @Override
    public void handleException(Context context, Throwable exception, String description) {
        if (this.fm.on("exc-basic")) {
            if (exception != null) {
                if (exception instanceof ServletException) {
                    ServletException servletException = (ServletException)exception;
                    this.logException(context, servletException.getRootCause(), description);
                } else {
                    this.logException(context, exception, description);
                }
                if (context != null) {
                    this.includeErrorPage(context, exception, description);
                }
            } else {
                this.log.log("Null exception passed to BasicExceptionHandler.  This should not happen.");
            }
        }
    }

    protected void logException(Context context, Throwable exception, String description) {
        if (this.displayExceptionsInLog) {
            if (StringHelper.isNonEmpty(description)) {
                this.log.log("Exception (" + description + "):\n" + exception);
            } else {
                this.log.log("Exception:\n" + exception);
            }
        }
        if (this.displayStackTracesInLog) {
            this.log.log("Stack trace: " + ThrowableHelper.getStackTrace(exception));
        }
    }

    protected void includeErrorPage(Context context, Throwable exception, String description) {
        if (this.useJson && GeminiHelper.isJsonRequest(context)) {
            HashMap<String, String> map = null;
            if (this.revealStackTrace) {
                map = new HashMap<String, String>();
                map.put("errorTrace", ThrowableHelper.convertStackTraceToString(exception));
            }
            GeminiHelper.sendJsonError(context, exception.getClass().getSimpleName(), "exception", exception.getMessage(), description, map);
        } else if (this.useErrorCode500) {
            context.sendError(500);
        } else if (StringHelper.isNonEmpty(this.errorTemplate) && !context.delivery().has("BasicExceptionHandler.handled")) {
            context.delivery().put("BasicExceptionHandler.handled", true);
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("exception", exception.toString());
            map.put("stackTrace", ThrowableHelper.getStackTrace(exception));
            map.put("description", description != null ? description : "No detail available.");
            map.put("reveal", this.revealStackTrace);
            try {
                this.application.getMustacheManager().render(this.errorTemplate, context, map);
            }
            catch (Exception exc) {
                this.outputDefaultErrorPage(context, exception, description);
            }
        } else {
            this.outputDefaultErrorPage(context, exception, description);
        }
    }

    protected void outputDefaultErrorPage(Context context, Throwable exception, String description) {
        if (this.revealStackTrace) {
            context.print("<html>");
            context.print("<head><title>Internal error</title>");
            context.print("<style>");
            context.print("body { background-color: white; color: black; }");
            context.print("p { font-family: Arial, Helvetica, Sans-serif; font-size: 12px; }");
            context.print("h2 { font-family: Arial, Helvetica, Sans-serif; font-size: 14px; font-weight: bold; }");
            context.print("pre { font-size: 9px; }");
            context.print("</style>");
            context.print("</head>");
            context.print("<body>");
            context.print("<!-- BasicExceptionHandler -->");
            context.print("<h2>Internal error</h2>");
            context.print("<p>An exception was caught by the application infrastructure:</p>");
            if (StringHelper.isNonEmpty(description)) {
                context.print("<p>" + description + "</p>");
            }
            context.print("<p><pre>");
            context.print(ThrowableHelper.convertStackTraceToString(exception));
            context.print("");
            context.print("</pre></p>");
            if (exception instanceof ServletException) {
                ServletException servletException = (ServletException)exception;
                if (servletException.getRootCause() != null) {
                    context.print("<p>Root cause:</p>");
                    context.print("<p><pre>");
                    context.print(ThrowableHelper.convertStackTraceToString(servletException.getRootCause()));
                    context.print("");
                    context.print("</pre></p>");
                } else {
                    context.print("<p>No root cause provided.</p>");
                }
            }
            context.print("</body>");
            context.print("</html>");
        } else {
            context.print("<html><head>");
            context.print("<title>Server Error</title>");
            context.print("<style>");
            context.print("body { background-color: white; color: black; }");
            context.print("p, div { color: white; font-family: Tahoma, Verdana, Arial, Helvetica, Sans-serif; font-size: 14px; }");
            context.print(".container { border: 8px solid #777777; width: 350px; }");
            context.print(".banner { background: #D06060; color: white; font-weight: bold; padding: 4px }");
            context.print(".text { background: #777777; padding: 4px; }");
            context.print("</style>");
            context.print("</head><body>");
            context.print("<!-- BasicExceptionHandler -->");
            context.print("<div class=\"container\">");
            context.print("<div class=\"banner\">Please bear with us...</div>");
            context.print("<div class=\"text\">We're sorry, our web site is not able to process your request correctly at this time.  Please try again at a later time.  If this situation persists, please get in touch with our customer service or technical support staff.</div>");
            context.print("</div>");
            context.print("<!--");
            if (StringHelper.isNonEmpty(description)) {
                context.print("\r\n" + description + "\r\n");
            }
            context.print(ThrowableHelper.convertStackTraceToString(exception));
            if (exception instanceof ServletException) {
                ServletException servletException = (ServletException)exception;
                context.print("Root cause:");
                context.print(ThrowableHelper.convertStackTraceToString(servletException.getRootCause()));
            }
            context.print("-->");
            context.print("</body></html>");
        }
    }
}

