/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.exceptionhandler;

import com.techempower.gemini.Context;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.session.Session;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.helper.ThrowableHelper;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletException;

public final class ExceptionHandlerHelper {
    private static final String[] IGNORED_HEADERS = new String[]{"Cookie", "SSL_CLIENT_CERT", "SSL_SERVER_CERT"};

    public static String renderExceptionAsReport(Context context, GeminiApplication application, Throwable exception, String description, int skipped) {
        StringBuilder message = new StringBuilder(2000);
        if (application != null) {
            message.append("Gemini Exception Report\n\n");
            message.append(String.valueOf(application.getVersion().getNameAndDeployment()) + '\n');
            message.append(String.valueOf(DateHelper.STANDARD_TECH_FORMAT.format(new Date())) + "\n\n");
        }
        if (context != null) {
            message.append("Request URL: " + context.getRequestSignature() + '\n');
            message.append("Client IP: " + context.getClientID() + '\n');
            Session session = context.getSession(false);
            message.append("Session ID: " + (session == null ? "no session" : session.getId()) + '\n');
        } else {
            message.append("No associated HTTP request.\n");
        }
        if (StringHelper.isNonEmpty(description)) {
            message.append("Description: " + description + '\n');
        }
        message.append('\n');
        if (skipped > 0) {
            message.append(String.valueOf(skipped) + " exception" + StringHelper.pluralize(skipped) + " skipped since last report\n\n");
        }
        message.append("----\n");
        message.append("Stack trace\n");
        message.append(ThrowableHelper.convertStackTraceToString(exception));
        message.append("----\n");
        if (exception instanceof ServletException) {
            ServletException servletException = (ServletException)exception;
            message.append("Root cause\n");
            message.append(ThrowableHelper.convertStackTraceToString(servletException.getRootCause()));
            message.append("----\n");
        }
        if (context != null) {
            message.append("Base URL: " + context.getRequest().getRequestURL() + '\n');
            message.append("Request headers\n");
            Enumeration<String> e = context.getRequest().getHeaderNames();
            while (e.hasMoreElements()) {
                String s = e.nextElement();
                if (Arrays.binarySearch(IGNORED_HEADERS, s) >= 0) continue;
                String val = context.getRequest().getHeader(s);
                message.append("  " + s + ": " + val + '\n');
            }
        }
        return message.toString();
    }

    private ExceptionHandlerHelper() {
    }
}

