/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.feature;

import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.feature.BasicFeatureNode;
import com.techempower.gemini.feature.FeatureManager;
import com.techempower.gemini.feature.FeatureNode;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BasicFeatureManager
implements FeatureManager,
Configurable {
    private final ComponentLog log;
    private final Map<String, FeatureNode> nodes;
    private final List<FeatureNode> roots;
    private Map<String, Boolean> status;

    public BasicFeatureManager(GeminiApplication application) {
        this.log = application.getLog("fMgr");
        this.status = new HashMap<String, Boolean>();
        this.nodes = new HashMap<String, FeatureNode>();
        this.roots = new ArrayList<FeatureNode>(2);
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public FeatureNode add(String featureKey, String description) {
        return this.add(featureKey, description, true);
    }

    @Override
    public FeatureNode add(String featureKey, String description, boolean defaultState) {
        BasicFeatureNode toReturn = new BasicFeatureNode(featureKey, description, defaultState, this, null);
        this.roots.add(toReturn);
        return toReturn;
    }

    @Override
    public FeatureNode get(String featureKey) {
        FeatureNode toReturn = this.nodes.get(featureKey);
        if (toReturn != null) {
            return toReturn;
        }
        return null;
    }

    @Override
    public void set(String featureKey, boolean enabled) {
        FeatureNode toChange = this.nodes.get(featureKey);
        if (toChange != null) {
            toChange.setEnabled(enabled);
            this.resetStatusMap();
        }
    }

    @Override
    public boolean on(String featureKey) {
        Boolean toReturn = this.status.get(featureKey);
        if (toReturn != null) {
            return toReturn;
        }
        return false;
    }

    @Override
    public List<FeatureNode> getRoots() {
        return new ArrayList<FeatureNode>(this.roots);
    }

    protected void enroll(BasicFeatureNode node) {
        if (this.nodes.get(node.getKey()) != null) {
            throw new IllegalArgumentException("Feature [" + node.getKey() + "] is already in the hierarchy.");
        }
        this.nodes.put(node.getKey(), node);
        this.status.put(node.getKey(), node.isFullyEnabled());
    }

    protected void buildStatusMap(Map<String, Boolean> statusMap, boolean enabled, Iterator<FeatureNode> iter) {
        while (iter.hasNext()) {
            FeatureNode node = iter.next();
            statusMap.put(node.getKey(), enabled && node.isEnabled());
            this.buildStatusMap(statusMap, enabled && node.isEnabled(), node.getChildren());
        }
    }

    protected void resetStatusMap() {
        HashMap<String, Boolean> newStatus = new HashMap<String, Boolean>();
        this.buildStatusMap(newStatus, true, this.roots.iterator());
        this.status = newStatus;
    }

    public String getConfiguration() {
        StringBuilder toReturn = new StringBuilder(5000);
        Iterator<FeatureNode> iter = this.roots.iterator();
        while (iter.hasNext()) {
            this.renderConfiguration(toReturn, "Feature.", iter.next());
        }
        return toReturn.toString();
    }

    public void renderConfiguration(StringBuilder buffer, String prefix, FeatureNode node) {
        buffer.append(String.valueOf(prefix) + node.getKey() + " = " + (node.isEnabled() ? "On" : "Off") + "\r\n");
        Iterator<FeatureNode> iter = node.getChildren();
        while (iter.hasNext()) {
            this.renderConfiguration(buffer, String.valueOf(prefix) + node.getKey() + ".", iter.next());
        }
    }

    public String getCollapsedConfiguration() {
        StringBuilder toReturn = new StringBuilder(5000);
        Iterator<String> iter = this.nodes.keySet().iterator();
        while (iter.hasNext()) {
            FeatureNode node = this.nodes.get(iter.next());
            toReturn.append("Feature." + node.getKey() + " = " + (this.status.get(node.getKey()) != false ? "On" : "Off") + "\r\n");
        }
        return toReturn.toString();
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.log.log("Configuring features.");
        EnhancedProperties features = props.extractProperties("Feature.", true);
        for (Object objKey : features.keySet()) {
            String key;
            if (!(objKey instanceof String)) continue;
            String originalKey = (String)objKey;
            if (originalKey.indexOf(46) >= 0) {
                String[] nodeArray = originalKey.split("\\.");
                key = nodeArray[nodeArray.length - 1];
            } else {
                key = originalKey;
            }
            FeatureNode node = this.get(key);
            if (node != null) {
                boolean enabled = features.getYesNoProperty(originalKey);
                node.setEnabled(enabled);
                continue;
            }
            this.log.log("Feature not found: " + key);
        }
        this.resetStatusMap();
    }
}

