/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.feature;

import com.techempower.gemini.feature.BasicFeatureManager;
import com.techempower.gemini.feature.FeatureNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BasicFeatureNode
implements FeatureNode {
    private final List<FeatureNode> children;
    private final BasicFeatureManager manager;
    private final BasicFeatureNode parent;
    private String key;
    private String description;
    private boolean enabled;

    public BasicFeatureNode(String key, String description, boolean enabled, BasicFeatureManager manager, BasicFeatureNode parent) {
        this.setKey(key);
        this.setEnabled(enabled);
        this.setDescription(description);
        this.children = new ArrayList<FeatureNode>(2);
        this.manager = manager;
        this.parent = parent;
        manager.enroll(this);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public FeatureNode add(String featureKey, String featureDescription) {
        return this.add(featureKey, featureDescription, true);
    }

    @Override
    public FeatureNode add(String featureKey, String featureDescription, boolean defaultState) {
        this.children.add(new BasicFeatureNode(featureKey, featureDescription, defaultState, this.manager, this));
        return this;
    }

    @Override
    public Iterator<FeatureNode> getChildren() {
        return this.children.iterator();
    }

    protected boolean isFullyEnabled() {
        if (!this.isEnabled()) {
            return false;
        }
        BasicFeatureNode node = this.parent;
        while (node != null) {
            if (!node.isEnabled()) {
                return false;
            }
            node = node.parent;
        }
        return true;
    }
}

