/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.filestore;

import com.techempower.gemini.BasicDispatcher;
import com.techempower.gemini.GeminiApplication;
import com.techempower.gemini.Handler;
import com.techempower.gemini.LegacyContext;
import com.techempower.gemini.filestore.FileStore;
import com.techempower.gemini.filestore.StoredFile;
import com.techempower.gemini.pyxis.PyxisUser;
import com.techempower.log.ComponentLog;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;

public class BasicFileStoreHandler
implements Handler<BasicDispatcher, LegacyContext>,
Configurable {
    public static final String COMPONENT_CODE = "hFsh";
    public static final String DEFAULT_PROPS_PREFIX = "FileStoreHandler.";
    public static final String CMD_PREFIX = "fs-";
    public static final String CMD_LIST_FILES = "fs-list";
    public static final String CMD_DELETE_FILE = "fs-delete";
    public static final String CMD_MANAGE_FILES = "fs-manage";
    public static final String JSP_LIST_FILES = "fs-list.jsp";
    private final GeminiApplication application;
    private final ComponentLog log;
    private final FileStore fileStore;

    public BasicFileStoreHandler(GeminiApplication application, FileStore fileStore) {
        this(application, fileStore, "FileStore.");
    }

    public BasicFileStoreHandler(GeminiApplication application, FileStore fileStore, String propsPrefix) {
        this.fileStore = fileStore;
        this.log = application.getLog(COMPONENT_CODE);
        this.application = application;
        application.getConfigurator().addConfigurable(this);
    }

    @Override
    public String getDescription() {
        return "Basic File Store handler";
    }

    @Override
    public int getPriority() {
        return -1000;
    }

    @Override
    public boolean acceptRequest(BasicDispatcher dispatcher, LegacyContext context, String command) {
        return command.startsWith(CMD_PREFIX);
    }

    @Override
    public boolean handleRequest(BasicDispatcher dispatcher, LegacyContext context, String command) {
        this.log.log("Handling: " + command);
        if (command.equalsIgnoreCase(CMD_LIST_FILES)) {
            return this.listFiles(dispatcher, context);
        }
        if (command.equalsIgnoreCase(CMD_MANAGE_FILES)) {
            return this.manageFiles(dispatcher, context);
        }
        return false;
    }

    protected boolean listFiles(BasicDispatcher dispatcher, LegacyContext context) {
        PyxisUser user = this.application.getSecurity().getUser(context);
        if (user != null) {
            this.fileStore.prepDirectory(user);
            StoredFile[] files = this.fileStore.getFileList(user);
            context.delivery().putObject("Files", files);
            return context.render(JSP_LIST_FILES);
        }
        return false;
    }

    protected boolean manageFiles(BasicDispatcher dispatcher, LegacyContext context) {
        PyxisUser user = this.application.getSecurity().getUser(context);
        if (user != null) {
            this.fileStore.processManagement(user, context);
            return context.render(JSP_LIST_FILES);
        }
        return false;
    }

    @Override
    public void configure(EnhancedProperties props) {
    }
}

