/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.filestore;

import com.techempower.gemini.email.EmailAttachment;
import com.techempower.gemini.email.EmailHandler;
import com.techempower.gemini.email.EmailPackage;
import com.techempower.gemini.filestore.FileStore;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.util.Identifiable;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;

public class FileStoreEmailHandler
implements EmailHandler {
    private final FileStore store;

    public FileStoreEmailHandler(FileStore store) {
        this.store = store;
    }

    @Override
    public boolean handleEmail(EmailPackage email) {
        Identifiable ident = this.getIdentifiable(email);
        if (ident != null) {
            try {
                this.store.getLog().log("Processing email for " + ident);
                String emailText = "Subject: " + email.getSubject() + "\r\n" + "\r\n" + email.getTextBody();
                ByteArrayInputStream bais = new ByteArrayInputStream(emailText.getBytes(StandardCharsets.UTF_8));
                this.store.storeFile(bais, ident, "email-" + DateHelper.STANDARD_FILENAME_FORMAT.format(new Date()) + ".txt");
                int processed = 1;
                Collection<EmailAttachment> attach = email.getAttachments();
                if (attach != null) {
                    for (EmailAttachment att : attach) {
                        this.store.storeFile(att.getInputStream(), ident, att.getName());
                        ++processed;
                    }
                }
                this.store.getLog().log("Processed " + processed + " attachment" + StringHelper.pluralize(processed) + " (including body text)");
                return true;
            }
            catch (Exception exc) {
                this.store.getLog().log("Exception while handling email: " + exc);
            }
        }
        return false;
    }

    public Identifiable getIdentifiable(EmailPackage email) {
        return null;
    }
}

