/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.filestore;

import com.techempower.helper.FileHelper;
import com.techempower.js.JavaScriptObject;
import com.techempower.js.ReflectiveVisitorFactory;
import com.techempower.js.VisitorFactory;

public class StoredFile
implements JavaScriptObject {
    public static final short TYPE_PLAIN = 0;
    public static final short TYPE_IMAGE = 1;
    public static final short TYPE_TEXT = 2;
    public static final short TYPE_BINARY = 3;
    private static final String[] TYPE_NAMES = new String[]{"Unknown file type", "Image", "Text or document", "Binary"};
    private static final int[] TYPE_VALUES;
    private String filename;
    private String url;
    private long size;
    private static final VisitorFactory<StoredFile> JSVF;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        TYPE_VALUES = nArray;
        JSVF = new ReflectiveVisitorFactory<StoredFile>(StoredFile.class, "filename", "getFilename", "url", "getUrl", "size", "getSize", "type", "getRoughType");
    }

    public StoredFile(String filename, String url, long size) {
        this.setFilename(filename);
        this.setUrl(url);
        this.setSize(size);
    }

    public String getFilename() {
        return this.filename;
    }

    public int getRoughType() {
        block45: {
            if (this.getFilename() == null) break block45;
            switch (FileHelper.getExtension(this.getFilename().toLowerCase())) {
                case "gif": 
                case "jpg": 
                case "png": 
                case "jpeg": {
                    return 1;
                }
                case "js": 
                case "doc": 
                case "log": 
                case "ppt": 
                case "sql": 
                case "txt": 
                case "xls": 
                case "xml": 
                case "docx": 
                case "html": 
                case "xlsx": {
                    return 2;
                }
                case "7z": 
                case "dat": 
                case "rar": 
                case "zip": {
                    return 3;
                }
            }
        }
        return 0;
    }

    public String getExtension() {
        return FileHelper.getExtension(this.getFilename().toLowerCase());
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getSizeKiB() {
        return (int)Math.max(this.getSize() / 1024L, 1L);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return "File [" + this.getFilename() + "; " + this.getSize() + "b]";
    }

    public VisitorFactory<StoredFile> getJsVisitorFactory() {
        return JSVF;
    }

    public static String[] getTypeNames() {
        return (String[])TYPE_NAMES.clone();
    }

    public static int[] getTypeValues() {
        return (int[])TYPE_VALUES.clone();
    }
}

