/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.filter;

import com.techempower.gemini.filter.BasicFilter;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.StringHelper;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThrottleFilter
extends BasicFilter {
    public static final String PARAM_CLIENT_IP = "ClientIP";
    private final ConcurrentHashMap<String, AtomicInteger> addressCache = new ConcurrentHashMap();
    private int maxConcurrentRequests = 2;
    private String[] welcomeIpAddressPatterns = null;
    private String[] welcomeAbuserUserAgents = null;
    private String[] welcomeAbuserUris = null;
    private String[] bannedUserAgents = null;
    private String[] bannedIpAddressPatterns = null;

    @Override
    public void init(FilterConfig config) {
        super.init(config);
        this.maxConcurrentRequests = (int)this.getInitParameter(config, "MaxConcurrentRequests", this.maxConcurrentRequests);
        this.debug("max concurrent requests: " + this.maxConcurrentRequests, 0);
        String unthrottledIpAddressPatterns = this.getInitParameter(config, "UnthrottledIpAddressPatterns", null);
        this.welcomeIpAddressPatterns = StringHelper.splitTrimAndLower(unthrottledIpAddressPatterns, ",");
        if (CollectionHelper.isNonEmpty(this.welcomeIpAddressPatterns)) {
            int i = 0;
            while (i < this.welcomeIpAddressPatterns.length) {
                this.debug("will not throttle this IP address pattern: " + this.welcomeIpAddressPatterns[i], 0);
                ++i;
            }
        } else {
            this.debug("will throttle all IP address patterns.", 0);
        }
        String unthrottledUserAgentConfig = this.getInitParameter(config, "UnthrottledUserAgents", null);
        this.welcomeAbuserUserAgents = StringHelper.splitTrimAndLower(unthrottledUserAgentConfig, ",");
        if (CollectionHelper.isNonEmpty(this.welcomeAbuserUserAgents)) {
            int i = 0;
            while (i < this.welcomeAbuserUserAgents.length) {
                this.debug("will not throttle this User-Agent: " + this.welcomeAbuserUserAgents[i], 0);
                ++i;
            }
        } else {
            this.debug("will throttle all User-Agents.", 0);
        }
        String bannedUserAgentConfig = this.getInitParameter(config, "BannedUserAgents", null);
        this.bannedUserAgents = StringHelper.splitTrimAndLower(bannedUserAgentConfig, ",");
        if (CollectionHelper.isNonEmpty(this.bannedUserAgents)) {
            int i = 0;
            while (i < this.bannedUserAgents.length) {
                this.debug("will ban this User-Agent: " + this.bannedUserAgents[i], 0);
                ++i;
            }
        } else {
            this.debug("will not ban any User-Agents.", 0);
        }
        String bannedIpAddressConfig = this.getInitParameter(config, "BannedIpAddressPatterns", null);
        this.bannedIpAddressPatterns = StringHelper.splitTrimAndLower(bannedIpAddressConfig, ",");
        if (CollectionHelper.isNonEmpty(this.bannedIpAddressPatterns)) {
            int i = 0;
            while (i < this.bannedIpAddressPatterns.length) {
                this.debug("will ban this IP address pattern: " + this.bannedIpAddressPatterns[i], 0);
                ++i;
            }
        } else {
            this.debug("will not ban any IP address patterns.", 0);
        }
        String unthrottledUriConfig = this.getInitParameter(config, "UnthrottledUris", null);
        this.welcomeAbuserUris = StringHelper.splitTrimAndLower(unthrottledUriConfig, ",");
        if (CollectionHelper.isNonEmpty(this.welcomeAbuserUris)) {
            int i = 0;
            while (i < this.welcomeAbuserUris.length) {
                this.debug("will not throttle this URI: " + this.welcomeAbuserUris[i], 0);
                ++i;
            }
        } else {
            this.debug("will throttle all URIs.", 0);
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        String ipAddress = request.getRemoteAddr();
        String clientIp = ((HttpServletRequest)request).getHeader(PARAM_CLIENT_IP);
        if (clientIp != null && clientIp.length() > 0) {
            ipAddress = clientIp;
        }
        String userAgent = ((HttpServletRequest)request).getHeader("User-Agent");
        String requestSignature = this.getRequestSignature((HttpServletRequest)request);
        this.debug("ipAddress:  " + ipAddress, 3);
        this.debug("User-Agent:  " + userAgent, 3);
        this.debug("Request sig: " + requestSignature, 3);
        if (this.isWelcomeIpAddressPattern(ipAddress)) {
            this.debug(String.valueOf(ipAddress) + " is an approved IP address pattern.", 3);
            chain.doFilter(request, response);
            return;
        }
        boolean bannedIp = this.isBannedIpAddress(ipAddress);
        if (!bannedIp && this.isWelcomeAbuser(userAgent)) {
            this.debug(String.valueOf(ipAddress) + " has approved User-Agent: " + userAgent, 3);
            chain.doFilter(request, response);
            return;
        }
        if (!bannedIp && this.isWelcomeAbuserUri(requestSignature)) {
            this.debug(String.valueOf(ipAddress) + " has approved URI: " + requestSignature, 3);
            chain.doFilter(request, response);
            return;
        }
        if (bannedIp) {
            this.debug(String.valueOf(ipAddress) + " has banned IP address", 3);
        } else if (this.isBannedUserAgent(userAgent)) {
            this.debug(String.valueOf(ipAddress) + " has banned User-Agent: " + userAgent, 3);
        } else {
            int count = 0;
            AtomicInteger atomic = this.addressCache.get(ipAddress);
            if (atomic == null) {
                atomic = this.addressCache.putIfAbsent(ipAddress, new AtomicInteger(1));
                if (atomic != null) {
                    count = atomic.get();
                } else {
                    atomic = this.addressCache.get(ipAddress);
                    count = 1;
                }
            } else {
                count = atomic.get() + 1;
            }
            if (count < this.maxConcurrentRequests) {
                try {
                    count = atomic.incrementAndGet();
                    chain.doFilter(request, response);
                    return;
                }
                catch (Exception e) {
                    this.debug("Exception: " + e, 1);
                }
                finally {
                    if (atomic != null && (count = atomic.decrementAndGet()) <= 0) {
                        this.addressCache.remove(ipAddress);
                    }
                }
            }
        }
        String msg = String.valueOf(System.currentTimeMillis()) + " - " + StringHelper.padSpace(ipAddress, 15) + " - " + userAgent + " - throttling request for " + requestSignature;
        this.debug(msg, 2);
        if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).sendError(503);
        }
    }

    private boolean isWelcomeIpAddressPattern(String ipAddress) {
        if (ipAddress != null) {
            int i = 0;
            while (i < this.welcomeIpAddressPatterns.length) {
                if (ipAddress.toLowerCase().contains(this.welcomeIpAddressPatterns[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isWelcomeAbuser(String userAgent) {
        if (userAgent != null) {
            int i = 0;
            while (i < this.welcomeAbuserUserAgents.length) {
                if (userAgent.toLowerCase().contains(this.welcomeAbuserUserAgents[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isBannedUserAgent(String userAgent) {
        if (userAgent != null) {
            int i = 0;
            while (i < this.bannedUserAgents.length) {
                if (userAgent.toLowerCase().contains(this.bannedUserAgents[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isBannedIpAddress(String ipAddress) {
        if (ipAddress != null) {
            int i = 0;
            while (i < this.bannedIpAddressPatterns.length) {
                if (ipAddress.contains(this.bannedIpAddressPatterns[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isWelcomeAbuserUri(String uri) {
        if (uri != null) {
            int i = 0;
            while (i < this.welcomeAbuserUris.length) {
                if (uri.toLowerCase().contains(this.welcomeAbuserUris[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getRequestSignature(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (StringHelper.isNonEmpty(queryString)) {
            return request.getRequestURL() + "?" + queryString;
        }
        return request.getRequestURL().toString();
    }
}

