/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormRevertableElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;

public class FormCheckBox
extends FormElement
implements FormRevertableElement {
    public static final String DEFAULT_VALUE = "y";
    public static final String DEFAULT_TEXT = "";
    private String value;
    private String textLabel;
    private String onClickAction;
    private boolean startingChecked = false;
    private boolean checked = false;
    private boolean labelEnabled = true;

    public FormCheckBox(String name, String value, String textLabel, boolean required, boolean checked) {
        super(name, value, required);
        this.setTextLabel(textLabel);
        this.setDisplayName(textLabel);
        this.setStartingChecked(checked);
        this.setChecked(checked);
    }

    public FormCheckBox(String name, String value, String textLabel, boolean required, boolean checked, Form form) {
        super(name, value, required, form);
        this.setTextLabel(textLabel);
        this.setDisplayName(textLabel);
        this.setStartingChecked(checked);
        this.setChecked(checked);
    }

    public FormCheckBox(String name, String value, String textLabel, boolean required) {
        this(name, value, textLabel, required, false);
    }

    public FormCheckBox(String name, String value, String textLabel, boolean required, Form form) {
        this(name, value, textLabel, required, false, form);
    }

    public FormCheckBox(String name, String textLabel, boolean required, boolean checked) {
        this(name, DEFAULT_VALUE, textLabel, required, checked);
    }

    public FormCheckBox(String name, String textLabel, boolean required, boolean checked, Form form) {
        this(name, DEFAULT_VALUE, textLabel, required, checked, form);
    }

    public FormCheckBox(String name, String textLabel, boolean required) {
        this(name, DEFAULT_VALUE, textLabel, required, false);
    }

    public FormCheckBox(String name, String textLabel, boolean required, Form form) {
        this(name, DEFAULT_VALUE, textLabel, required, false, form);
    }

    public FormCheckBox(String name, boolean required, boolean checked) {
        super(name, DEFAULT_VALUE, required);
        this.setStartingChecked(checked);
        this.setChecked(checked);
        this.setTextLabelEnabled(false);
    }

    public FormCheckBox(String name, boolean required, boolean checked, Form form) {
        super(name, DEFAULT_VALUE, required, form);
        this.setStartingChecked(checked);
        this.setChecked(checked);
        this.setTextLabelEnabled(false);
    }

    public FormCheckBox(String name, boolean required) {
        this(name, DEFAULT_VALUE, DEFAULT_TEXT, required);
    }

    public FormCheckBox(String name, boolean required, Form form) {
        this(name, DEFAULT_VALUE, DEFAULT_TEXT, required, form);
    }

    public FormCheckBox(String name) {
        this(name, DEFAULT_VALUE, DEFAULT_TEXT, false);
    }

    public FormCheckBox(String name, Form form) {
        this(name, DEFAULT_VALUE, DEFAULT_TEXT, false, form);
    }

    public FormCheckBox setChecked(boolean checked) {
        this.checked = checked;
        return this;
    }

    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public FormCheckBox setValue(String value) {
        if (!this.isReadOnly()) {
            if (this.value == null) {
                this.value = value;
            }
            this.setChecked(value != null && value.length() > 0);
        }
        return this;
    }

    public FormCheckBox setStartingChecked(boolean check) {
        this.startingChecked = check;
        return this;
    }

    public boolean getStartingChecked() {
        return this.startingChecked;
    }

    @Override
    public FormCheckBox revert() {
        this.setChecked(this.getStartingChecked());
        return this;
    }

    @Override
    public FormElement setValue(Context context) {
        this.setValue(context.query().get(this.getName(), DEFAULT_TEXT));
        return this;
    }

    public String getTextLabel() {
        if (this.textLabel == null) {
            return DEFAULT_TEXT;
        }
        return this.textLabel;
    }

    public FormCheckBox setTextLabel(String textLabel) {
        this.textLabel = textLabel;
        this.setTextLabelEnabled(StringHelper.isNonEmpty(textLabel));
        return this;
    }

    @Deprecated
    public void setText(String textLabel) {
        this.setTextLabel(textLabel);
    }

    @Deprecated
    public String getText() {
        return this.getTextLabel();
    }

    public FormCheckBox setTextLabelEnabled(boolean enabled) {
        this.labelEnabled = enabled;
        return this;
    }

    protected String getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public String getRenderableValue() {
        return NetworkHelper.escapeStringForHtml(this.getValue());
    }

    @Override
    public String getEscapedValue() {
        return StringHelper.escapeSingleQuotes(this.getValue());
    }

    @Override
    public int getIntegerValue() {
        return NumberHelper.parseInt(this.getValue(), 0);
    }

    @Override
    public String render() {
        return this.render(this.getStyle(), this.labelEnabled);
    }

    @Override
    public String render(String cssCode) {
        return this.render(cssCode, this.labelEnabled);
    }

    public String render(boolean pWithLabel) {
        return this.render(this.getStyle(), pWithLabel);
    }

    public String render(String cssCode, boolean pWithLabel) {
        StringBuilder buffer = new StringBuilder(80);
        buffer.append("<input type=\"checkbox\"");
        buffer.append(this.renderId());
        buffer.append(" name=\"" + NetworkHelper.escapeStringForHtml(this.getName()) + "\"");
        buffer.append(" value=\"" + NetworkHelper.escapeStringForHtml(this.getValue()) + "\"");
        if (this.isChecked()) {
            buffer.append(" checked=\"checked\"");
        }
        if (this.onClickAction != null) {
            buffer.append(" onclick=\"");
            buffer.append(this.onClickAction);
            buffer.append("\" ");
        }
        buffer.append(this.renderClassName());
        if (this.isRequired() && this.isUsingHTML5Forms() && this.isValidationEnabled()) {
            buffer.append(" required=\"required\"");
        }
        buffer.append(this.renderTabIndex());
        buffer.append(this.renderFormEvents());
        buffer.append(this.renderEnabled());
        buffer.append(this.renderStyle(cssCode));
        buffer.append("/>");
        if (this.labelEnabled && !pWithLabel) {
            buffer.append(this.getTextLabel());
        } else if (this.labelEnabled && pWithLabel) {
            buffer.append(this.renderLabel(cssCode));
        }
        return buffer.toString();
    }

    public String renderLabel(boolean enableClickOnLabel) {
        if (enableClickOnLabel) {
            return "<label for=\"" + (StringHelper.isNonEmpty(this.getId()) ? this.getId() : this.getName()) + "\">" + this.getTextLabel() + "</label>";
        }
        return this.getTextLabel();
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        if (this.isRequired() && !this.isChecked()) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gfcb-unchecked-e", macros, "gfcb-unchecked-i", macros, "gfcb-unchecked-l", macros);
        }
    }

    public FormCheckBox setAction(String action) {
        this.onClickAction = action;
        return this;
    }
}

