/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormCheckBox;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormRevertableElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.StringHelper;
import com.techempower.util.StringList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class FormCheckBoxGroup
extends FormElement
implements FormRevertableElement {
    public static final int DEFAULT_NUMBER_OF_REQUIRED_CHECKBOXES = 0;
    public static final String SEPARATOR = "_";
    public static final String DEFAULT_VALUE = "";
    public static final String DEFAULT_LABEL = "";
    public static final boolean CHECKED = true;
    public static final boolean UNCHECKED = false;
    private int minimumRequired;
    private int maximumAllowed;
    private List<FormCheckBox> selections = null;
    private List<FormCheckBox> startingSelections = null;
    private boolean incrementTabIndex = true;
    private boolean showLabels = true;

    public FormCheckBoxGroup(String groupName, Collection<FormCheckBox> checkboxes, int minChecked, int maxChecked) {
        super(groupName.trim());
        this.setStartingSelections(checkboxes);
        this.setSelections(this.getStartingSelections());
        this.setMinimumRequired(minChecked);
        this.setMaximumAllowed(maxChecked);
    }

    public FormCheckBoxGroup(String groupName, Collection<FormCheckBox> checkboxes, int minChecked, int maxChecked, Form form) {
        super(groupName.trim(), form);
        this.setStartingSelections(checkboxes);
        this.setSelections(this.getStartingSelections());
        this.setMinimumRequired(minChecked);
        this.setMaximumAllowed(maxChecked);
    }

    public FormCheckBoxGroup(String groupName, Collection<FormCheckBox> checkboxes, int minChecked) {
        this(groupName, checkboxes, minChecked, checkboxes.size());
    }

    public FormCheckBoxGroup(String groupName, Collection<FormCheckBox> checkboxes, int minChecked, Form form) {
        this(groupName, checkboxes, minChecked, checkboxes.size(), form);
    }

    public FormCheckBoxGroup(String groupName, Collection<FormCheckBox> checkboxes) {
        this(groupName, checkboxes, 0);
    }

    public FormCheckBoxGroup(String groupName, Collection<FormCheckBox> checkboxes, Form form) {
        this(groupName, checkboxes, 0, form);
    }

    public FormCheckBoxGroup(String groupName, String[] names, String[] values, boolean[] states, String[] labels, int minChecked, int maxChecked) {
        super(groupName.trim());
        this.setStartingSelections(this.constructCheckBoxes(names, values, states, labels));
        this.setSelections(this.getStartingSelections());
        this.setMinimumRequired(minChecked);
        this.setMaximumAllowed(maxChecked);
    }

    public FormCheckBoxGroup(String groupName, String[] names, String[] values, boolean[] states, String[] labels, int minChecked, int maxChecked, Form form) {
        super(groupName.trim(), form);
        this.setStartingSelections(this.constructCheckBoxes(names, values, states, labels));
        this.setSelections(this.getStartingSelections());
        this.setMinimumRequired(minChecked);
        this.setMaximumAllowed(maxChecked);
    }

    public FormCheckBoxGroup(String groupName, String[] names, String[] values, boolean[] states, String[] labels, int minChecked) {
        this(groupName, names, values, states, labels, minChecked, names.length);
    }

    public FormCheckBoxGroup(String groupName, String[] names, String[] values, boolean[] states, String[] labels, int minChecked, Form form) {
        this(groupName, names, values, states, labels, minChecked, names.length, form);
    }

    public FormCheckBoxGroup(String groupName, String[] names, String[] values, boolean[] states, String[] labels) {
        this(groupName, names, values, states, labels, 0);
    }

    public FormCheckBoxGroup(String groupName, String[] names, String[] values, boolean[] states, String[] labels, Form form) {
        this(groupName, names, values, states, labels, 0, form);
    }

    protected Collection<FormCheckBox> constructCheckBoxes(String[] names, String[] values, boolean[] states, String[] labels) {
        Object[] newLabels;
        boolean[] newStates;
        ArrayList<FormCheckBox> boxes = new ArrayList<FormCheckBox>(names.length);
        Object[] newValues = values;
        if (newValues == null) {
            newValues = new String[names.length];
            Arrays.fill(newValues, "");
        }
        if ((newStates = states) == null) {
            newStates = new boolean[names.length];
            Arrays.fill(newStates, false);
        }
        if ((newLabels = labels) == null) {
            newLabels = new String[names.length];
            Arrays.fill(newLabels, "");
        }
        int i = 0;
        while (i < names.length) {
            FormCheckBox box = new FormCheckBox(names[i], (String)newValues[i], (String)newLabels[i], false, newStates[i]);
            boxes.add(box);
            ++i;
        }
        return boxes;
    }

    protected void setStartingSelections(Collection<FormCheckBox> selected) {
        this.startingSelections = new ArrayList<FormCheckBox>(selected.size());
        for (FormCheckBox box : selected) {
            this.addCheckBox(box);
        }
    }

    public Collection<FormCheckBox> getStartingSelections() {
        return this.startingSelections;
    }

    protected void setSelections(Collection<FormCheckBox> selected) {
        this.selections = new ArrayList<FormCheckBox>(selected);
    }

    public Collection<FormCheckBox> getSelections() {
        return this.selections;
    }

    public FormCheckBox getSelectionByName(String strName) {
        if (this.selections == null || this.selections.isEmpty()) {
            return null;
        }
        for (FormCheckBox oBox : this.selections) {
            String name = oBox.getName();
            if (name == null || !name.equals(strName)) continue;
            return oBox;
        }
        return null;
    }

    public FormCheckBox getSelectionByValue(String strValue) {
        if (this.selections == null || this.selections.isEmpty()) {
            return null;
        }
        for (FormCheckBox oBox : this.selections) {
            String val = oBox.getValue();
            if (val == null || !val.equals(strValue)) continue;
            return oBox;
        }
        return null;
    }

    public Collection<FormCheckBox> getSelection(boolean isChecked) {
        ArrayList<FormCheckBox> checked = new ArrayList<FormCheckBox>();
        if (CollectionHelper.isNonEmpty(this.selections)) {
            for (FormCheckBox box : this.selections) {
                if (box == null || box.isChecked() != isChecked) continue;
                checked.add(box);
            }
        }
        return checked;
    }

    public String[] getSelectionValues(boolean isChecked) {
        Collection<FormCheckBox> checkBoxes = this.getSelection(isChecked);
        String[] values = new String[]{};
        if (CollectionHelper.isNonEmpty(checkBoxes)) {
            values = new String[checkBoxes.size()];
            int index = 0;
            for (FormCheckBox checkBox : checkBoxes) {
                if (checkBox == null) continue;
                values[index++] = checkBox.getValue();
            }
        }
        return values;
    }

    public int[] getSelectionValuesAsInts(boolean isChecked) {
        return CollectionHelper.toIntArray(this.getSelectionValues(isChecked));
    }

    public FormCheckBox getCheckBox(int buttonNumber) {
        if (CollectionHelper.isNonEmpty(this.selections) && buttonNumber >= 0 && buttonNumber < this.selections.size()) {
            return this.selections.get(buttonNumber);
        }
        return null;
    }

    @Override
    @Deprecated
    public FormElement setValue(String value) {
        return this;
    }

    @Override
    public FormElement setValue(Context context) {
        if (this.startingSelections == null || this.startingSelections.isEmpty()) {
            return this;
        }
        ArrayList<FormCheckBox> fromContext = new ArrayList<FormCheckBox>(this.startingSelections.size());
        int index = 0;
        int i = 0;
        while (i < this.startingSelections.size()) {
            FormCheckBox startingBox = this.startingSelections.get(i);
            String value = context.query().get(startingBox.getName());
            boolean state = value != null;
            FormCheckBox newBox = new FormCheckBox(startingBox.getName(), startingBox.getValue(), startingBox.getTextLabel(), false, state);
            fromContext.add(index, newBox);
            ++index;
            ++i;
        }
        this.setSelections(fromContext);
        return this;
    }

    @Deprecated
    protected String getValue() {
        if (this.selections != null) {
            StringList list = new StringList(", ");
            Iterator<FormCheckBox> iter = this.selections.iterator();
            while (iter.hasNext()) {
                list.add("");
            }
            return list.toString();
        }
        return "";
    }

    @Override
    @Deprecated
    public String getStringValue() {
        return "";
    }

    @Override
    @Deprecated
    public String getRenderableValue() {
        return "";
    }

    public Collection<String> getCheckedCheckBoxNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (FormCheckBox box : this.getSelections()) {
            if (!box.isChecked()) continue;
            String name = this.separateComplexName(box.getName());
            names.add(name);
        }
        return names;
    }

    public Collection<String> getCheckedCheckBoxEscapedNames() {
        ArrayList<String> escaped = new ArrayList<String>();
        for (FormCheckBox box : this.getSelections()) {
            if (!box.isChecked()) continue;
            String name = this.separateComplexName(box.getName());
            escaped.add(StringHelper.escapeSingleQuotes(name));
        }
        return escaped;
    }

    @Override
    @Deprecated
    public String getEscapedValue() {
        return "";
    }

    public void addCheckBox(FormCheckBox box) {
        box.setName(this.constructComplexName(box.getName()));
        this.startingSelections.add(box);
        if (this.selections == null) {
            this.selections = new ArrayList<FormCheckBox>();
        }
        this.selections.add(box);
    }

    protected String constructComplexName(String name) {
        if (StringHelper.isNonEmpty(name)) {
            return String.valueOf(this.getName()) + SEPARATOR + name.trim();
        }
        return this.getName();
    }

    protected String separateComplexName(String name) {
        if (name.equalsIgnoreCase(this.getName())) {
            return name;
        }
        return name.substring(this.getName().length() + SEPARATOR.length());
    }

    public int getCheckBoxCount() {
        if (this.startingSelections == null || this.startingSelections.isEmpty()) {
            return 0;
        }
        return this.startingSelections.size();
    }

    public int getMinimumRequired() {
        return this.minimumRequired;
    }

    public void setMinimumRequired(int min) {
        this.minimumRequired = min < 0 ? 0 : (min > this.getCheckBoxCount() ? this.getCheckBoxCount() : min);
    }

    public int getMaximumAllowed() {
        return this.maximumAllowed;
    }

    public void setMaximumAllowed(int max) {
        this.maximumAllowed = max < this.getMinimumRequired() ? this.getMinimumRequired() : (max > this.getCheckBoxCount() ? this.getCheckBoxCount() : max);
    }

    @Override
    public boolean isRequired() {
        return this.getMinimumRequired() != 0;
    }

    @Override
    public FormCheckBoxGroup revert() {
        this.setSelections(this.getStartingSelections());
        return this;
    }

    public int getCheckedCount() {
        int count = 0;
        for (FormCheckBox box : this.selections) {
            if (!box.isChecked()) continue;
            ++count;
        }
        return count;
    }

    public boolean isChecked(int buttonNumber) {
        FormCheckBox cb = this.getCheckBox(buttonNumber);
        if (cb != null) {
            return cb.isChecked();
        }
        return false;
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(100);
        int i = 0;
        while (i < this.getCheckBoxCount()) {
            buffer.append(this.renderSingle(cssCode, i));
            ++i;
        }
        return buffer.toString();
    }

    public String renderSingle(String buttonName) {
        int i = 0;
        while (i < this.getCheckBoxCount()) {
            FormCheckBox box = this.startingSelections.get(i);
            String name = box.getName();
            if (name.equals(buttonName) || name.equals(this.constructComplexName(buttonName))) {
                return this.renderSingle(i);
            }
            ++i;
        }
        return "";
    }

    public String renderSingle(int buttonNumber) {
        return this.renderSingle(this.getStyle(), buttonNumber);
    }

    public String renderSingle(String cssCode, int buttonNumber) {
        return this.renderSingle(cssCode, buttonNumber, this.showLabels);
    }

    public String renderSingle(String cssCode, int buttonNumber, boolean showLabel) {
        if (buttonNumber >= 0 && buttonNumber < this.startingSelections.size()) {
            return this.selections.get(buttonNumber).render(cssCode, showLabel);
        }
        return "";
    }

    public String renderSingleLabel(String cssCode, int buttonNumber, boolean enableClickOnLabel) {
        if (buttonNumber >= 0 && buttonNumber < this.startingSelections.size()) {
            return this.selections.get(buttonNumber).renderLabel(enableClickOnLabel);
        }
        return "";
    }

    public String renderSingleLabel(int buttonNumber, boolean enableClickOnLabel) {
        return this.renderSingleLabel("", buttonNumber, enableClickOnLabel);
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        String[] macros = new String[]{this.getDisplayName(), Integer.toString(this.getMinimumRequired()), Integer.toString(this.getMaximumAllowed())};
        if (this.isRequired() && this.getCheckedCount() < this.getMinimumRequired()) {
            if (this.getMinimumRequired() == 1) {
                val.setError("gfcbg-lowsingular-e", macros, "gfcbg-lowsingular-i", macros, "gfcbg-lowsingular-l", macros);
            } else {
                val.setError("gfcbg-lowplural-e", macros, "gfcbg-lowplural-i", macros, "gfcbg-lowplural-l", macros);
            }
        }
        if (!val.isSet() && this.getCheckedCount() > this.getMaximumAllowed()) {
            if (this.getMaximumAllowed() == 1) {
                val.setError("gfcbg-highsingular-e", macros, "gfcbg-highsingular-i", macros, "gfcbg-highsingular-l", macros);
            } else {
                val.setError("gfcbg-highplural-e", macros, "gfcbg-highplural-i", macros, "gfcbg-highplural-l", macros);
            }
        }
    }

    public boolean isIncrementTabIndex() {
        return this.incrementTabIndex;
    }

    public FormCheckBoxGroup setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
        return this;
    }

    public FormCheckBoxGroup setIncrementTabIndex(boolean increment) {
        this.incrementTabIndex = increment;
        return this;
    }
}

