/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormDateFieldDropDown;
import com.techempower.gemini.form.FormSelect;
import java.util.Calendar;
import java.util.Date;

public class FormCreditCardDateFieldDropDown
extends FormDateFieldDropDown {
    public static final int YEAR_SPAN = 20;
    private int month = -1;
    private int year = -1;

    public FormCreditCardDateFieldDropDown(String name, String value, boolean required, int length) {
        super(name, value, required, length);
        this.setYearSpan(20);
    }

    public FormCreditCardDateFieldDropDown(String name, String value, boolean required, int length, Form form) {
        super(name, value, required, length, form);
        this.setYearSpan(20);
    }

    public FormCreditCardDateFieldDropDown(String name, Date value, boolean required, int length) {
        super(name, value, required, length);
        this.setYearSpan(20);
    }

    public FormCreditCardDateFieldDropDown(String name, Date value, boolean required, int length, Form form) {
        super(name, value, required, length, form);
        this.setYearSpan(20);
    }

    public FormCreditCardDateFieldDropDown(String name, Calendar value, boolean required, int length) {
        super(name, value, required, length);
        this.setYearSpan(20);
    }

    public FormCreditCardDateFieldDropDown(String name, Calendar value, boolean required, int length, Form form) {
        super(name, value, required, length, form);
        this.setYearSpan(20);
    }

    public FormCreditCardDateFieldDropDown(String name, boolean required, int length) {
        this(name, "", required, length);
        this.setYearSpan(20);
    }

    public FormCreditCardDateFieldDropDown(String name, boolean required, int length, Form form) {
        this(name, "", required, length, form);
        this.setYearSpan(20);
    }

    public FormCreditCardDateFieldDropDown(String name, int length) {
        this(name, "", false, length);
        this.setYearSpan(20);
    }

    public FormCreditCardDateFieldDropDown(String name, int length, Form form) {
        this(name, "", false, length, form);
        this.setYearSpan(20);
    }

    public FormCreditCardDateFieldDropDown(String name) {
        this(name, "", false, 20);
    }

    public FormCreditCardDateFieldDropDown(String name, Form form) {
        this(name, "", false, 20, form);
    }

    @Override
    public FormCreditCardDateFieldDropDown setValue(Context context) {
        int providedMonth = context.query().getInt(String.valueOf(this.getName()) + "-month", -1);
        int providedYear = context.query().getInt(String.valueOf(this.getName()) + "-year", -1);
        this.setValue(providedMonth, providedYear);
        return this;
    }

    public void setValue(int month, int year) {
        this.month = month;
        this.year = year;
        if (month > -1 && year > -1) {
            this.setValue(String.valueOf(month) + "/01/" + year);
        }
    }

    @Override
    public String render(String cssCode) {
        FormSelect monthMenu = this.buildMonthDropDown();
        FormSelect yearMenu = this.buildYearDropDown();
        monthMenu.setTabIndex(this.getTabIndex());
        yearMenu.setTabIndex(this.getTabIndex() + 1);
        return String.valueOf(monthMenu.render(cssCode)) + yearMenu.render(cssCode);
    }

    @Override
    public String render(String cssClassName, String cssCode) {
        FormSelect monthMenu = this.buildMonthDropDown();
        FormSelect yearMenu = this.buildYearDropDown();
        monthMenu.setTabIndex(this.getTabIndex());
        yearMenu.setTabIndex(this.getTabIndex() + 1);
        return String.valueOf(monthMenu.render(cssClassName, cssCode)) + yearMenu.render(cssClassName, cssCode);
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }
}

