/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;
import com.techempower.helper.CreditCardHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;

public class FormCreditCardField
extends FormTextField {
    public static final int TEXT_FIELD_LENGTH = 20;

    public FormCreditCardField(String displayName, String name, String value, boolean required) {
        super(displayName, name, value, required, 20, 20);
    }

    public FormCreditCardField(String displayName, String name, String value, boolean required, Form form) {
        super(displayName, name, value, required, 20, 20, form);
    }

    public FormCreditCardField(String name, String value, boolean required) {
        this(null, name, value, required);
    }

    public FormCreditCardField(String name, String value, boolean required, Form form) {
        this(null, name, value, required, form);
    }

    @Override
    public String getStringValue() {
        return StringHelper.stripNonNumeric(super.getStringValue());
    }

    @Override
    public int getIntegerValue() {
        return NumberHelper.parseInt(StringHelper.stripNonNumeric(this.getValue()));
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        String filteredValue;
        super.requiredValidation(val);
        if (!val.isSet() && (filteredValue = this.getStringValue()).length() > 0) {
            int validation = CreditCardHelper.validate(filteredValue);
            if (validation == 1) {
                val.setRawError(String.valueOf(this.getDisplayName()) + " does not appear to contain a properly-formatted credit card number.", "The credit card number in " + this.getDisplayName() + " does not appear to be properly formatted.", "Please provide a properly-formatted credit card number");
            } else if (validation == 2) {
                int type = CreditCardHelper.getType(filteredValue, false);
                if (type == 2) {
                    val.setRawError("Mastercard numbers are 16 digits long.", "The Mastercard number specified in " + this.getDisplayName() + " should contain 16 digits.", "Please correct this Mastercard number to contain 16 digits.");
                } else if (type == 1) {
                    val.setRawError("Visa numbers are 13 or 16 digits long.", "The Visa number specified in " + this.getDisplayName() + " should contain 13 or 16 digits.", "Please correct this Visa number to contain all 13 or 16 digits.");
                } else if (type == 4) {
                    val.setRawError("American Express numbers are 15 digits long.", "The American Express number specified in " + this.getDisplayName() + " should contain 15 digits.", "Please correct this American Express number to contain all 15 digits.");
                } else if (type == 3) {
                    val.setRawError("Discover numbers are 16 digits long.", "The Discover number specified in " + this.getDisplayName() + " should contain 16 digits.", "Please correct this Discover number to contain all 16 digits.");
                }
            } else if (validation == 3) {
                val.setRawError("The credit card number provided in " + this.getDisplayName() + " fails Luhn validation.", "The credit card specified in " + this.getDisplayName() + " is not valid.", "This credit card number is not valid.");
            }
        }
    }

    @Override
    protected void addClientSideValidationClasses() {
        this.addClassName("creditcard");
        super.addClientSideValidationClasses();
    }
}

