/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElementProcessor;
import com.techempower.gemini.form.FormElementValidator;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormValidation;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class FormElement {
    public static final String COMPONENT_CODE = "felt";
    private String name = "";
    private String displayName = null;
    private String helpText = null;
    private boolean required = false;
    private boolean autofocus = false;
    private boolean validationEnabled = true;
    private boolean readOnly = false;
    private int tabIndex = -1;
    private StringBuilder formEvents = null;
    private List<FormElementValidator> validators = null;
    private List<FormElementProcessor> processors = null;
    private boolean enabled = true;
    private String id = "";
    private Set<String> classNames = null;
    private String style = null;
    private boolean autocompleteDisabled = false;
    private Form form = null;
    private boolean validationError = false;
    private Map<String, Object> rules = null;
    private Boolean useHTML5Forms = null;
    private Boolean useClientSideValidation = null;

    public FormElement(String name, String value, boolean required, Form form) {
        this.setName(name);
        if (form != null) {
            form.add(this);
        }
        this.setValue(value != null ? value : "");
        this.setRequired(required);
    }

    public FormElement(String name, String value, boolean required) {
        this(name, value, required, null);
    }

    public FormElement(String name, boolean required, Form form) {
        this(name, "", required, form);
    }

    public FormElement(String name, boolean required) {
        this(name, required, null);
    }

    public FormElement(String name, Form form) {
        this(name, "", false, form);
    }

    public FormElement(String name) {
        this(name, null);
    }

    public FormElement setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public FormElement setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getName();
    }

    public FormElement setStyle(String cssCode) {
        this.style = cssCode;
        return this;
    }

    public void appendStyle(String cssCode) {
        if (StringHelper.isEmptyTrimmed(cssCode)) {
            return;
        }
        if (StringHelper.isEmptyTrimmed(this.style)) {
            this.setStyle(cssCode);
            return;
        }
        String baseStyle = this.style.trim();
        String addedStyle = cssCode.trim();
        while (baseStyle.endsWith(";")) {
            baseStyle = baseStyle.substring(0, baseStyle.length() - 1);
        }
        while (addedStyle.startsWith(";")) {
            addedStyle = addedStyle.substring(1);
        }
        this.setStyle(String.valueOf(baseStyle) + ";" + addedStyle);
    }

    public String getStyle() {
        return this.style;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public FormElement setHelpText(String helpText) {
        this.helpText = helpText;
        return this;
    }

    public String renderStyle(String cssCode) {
        if (cssCode != null && cssCode.length() > 0) {
            return " style=\"" + cssCode + '\"';
        }
        return "";
    }

    @Deprecated
    public void setClassName(String className) {
        if (this.classNames != null) {
            this.classNames.clear();
        }
        this.addClassName(className);
    }

    public String getClassName() {
        return StringHelper.join(" ", this.classNames);
    }

    public FormElement addClassName(String className) {
        String[] newClassNames;
        String[] stringArray = newClassNames = StringHelper.splitIntoWords(className);
        int n = newClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String newClassName = stringArray[n2];
            if (StringHelper.isNonEmptyTrimmed(newClassName)) {
                if (this.classNames == null) {
                    this.classNames = new HashSet<String>();
                }
                this.classNames.add(newClassName);
            }
            ++n2;
        }
        return this;
    }

    public FormElement removeClassName(String toRemove) {
        if (CollectionHelper.isNonEmpty(this.classNames) && StringHelper.isNonEmpty(toRemove)) {
            String[] stringArray = StringHelper.splitIntoWords(toRemove);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                this.classNames.remove(word);
                ++n2;
            }
        }
        return this;
    }

    public boolean hasClassName(String className) {
        return StringHelper.containsWord(this.getClassName(), className);
    }

    public String renderClassName() {
        if (CollectionHelper.isEmpty(this.classNames)) {
            return "";
        }
        return " class=\"" + NetworkHelper.escapeStringForHtml(this.getClassName()) + "\"";
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String renderId() {
        if (!StringHelper.isEmpty(this.id)) {
            return " id=\"" + this.id + '\"';
        }
        return " id=\"" + this.name + '\"';
    }

    public FormElement setRequired(boolean required) {
        this.required = required;
        if (required) {
            this.addRule("required", true);
        } else {
            this.removeRule("required");
        }
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isAutofocus() {
        return this.autofocus;
    }

    public FormElement setAutofocus(boolean autofocus) {
        this.autofocus = autofocus;
        return this;
    }

    public FormElement setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String renderReadOnly() {
        if (this.readOnly) {
            return " readonly=\"readonly\"";
        }
        return "";
    }

    public FormElement setAutocompleteDisabled(boolean autocompleteDisabled) {
        this.autocompleteDisabled = autocompleteDisabled;
        return this;
    }

    public boolean isAutocompleteDisabled() {
        return this.autocompleteDisabled;
    }

    public String renderAutocompleteDisabled() {
        if (this.autocompleteDisabled) {
            return " autocomplete=\"off\"";
        }
        return "";
    }

    public abstract FormElement setValue(String var1);

    public abstract FormElement setValue(Context var1);

    public abstract String getStringValue();

    public abstract String getRenderableValue();

    public abstract String getEscapedValue();

    public int getIntegerValue() {
        return NumberHelper.parseInt(this.getStringValue(), 0);
    }

    public long getLongValue() {
        return NumberHelper.parseLong(this.getStringValue(), 0L);
    }

    public abstract String render();

    public abstract String render(String var1);

    public String render(String cssClassName, String cssCode) {
        this.addClassName(cssClassName);
        return this.render(cssCode);
    }

    public String toString() {
        return this.render();
    }

    public FormSingleValidation validate(Context context, FormValidation formValidation) {
        FormSingleValidation val = new FormSingleValidation(this, context, formValidation);
        this.executeProcessors();
        if (this.isValidationEnabled()) {
            this.requiredValidation(val);
            this.executeValidators(val);
            this.customValidation(val);
            this.validationError = val.isError();
        }
        return val;
    }

    protected void requiredValidation(FormSingleValidation val) {
    }

    protected void executeProcessors() {
        if (this.processors != null) {
            for (FormElementProcessor processor : this.processors) {
                processor.process(this);
            }
        }
    }

    protected void executeValidators(FormSingleValidation val) {
        if (this.validators != null && !val.isSet()) {
            for (FormElementValidator validator : this.validators) {
                validator.validate(this, val);
                if (val.isSet()) break;
            }
        }
    }

    protected void customValidation(FormSingleValidation fsv) {
        if (!fsv.isSet()) {
            this.shortCustomValidation(fsv);
        }
    }

    protected void shortCustomValidation(FormSingleValidation fsv) {
    }

    public FormElement addProcessor(FormElementProcessor fep) {
        if (fep != null) {
            if (this.processors == null) {
                this.processors = new ArrayList<FormElementProcessor>(4);
            }
            this.processors.add(fep);
        }
        return this;
    }

    public FormElement addValidator(FormElementValidator fev) {
        if (fev != null) {
            if (this.validators == null) {
                this.validators = new ArrayList<FormElementValidator>(4);
            }
            this.validators.add(fev);
        }
        return this;
    }

    public void clearValidators() {
        if (this.validators != null) {
            this.validators.clear();
        }
    }

    public void removeValidator(FormElementValidator fev) {
        if (this.validators != null) {
            this.validators.remove(fev);
        }
    }

    public FormElement setTabIndex(int order) {
        this.tabIndex = order;
        return this;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public String renderTabIndex() {
        if (this.tabIndex >= 0) {
            return " tabindex=\"" + this.tabIndex + "\" ";
        }
        return "";
    }

    public void addFormEvent(String event, String action) {
        if (event != null && action != null) {
            if (this.formEvents == null) {
                this.formEvents = new StringBuilder(50);
            }
            this.formEvents.append(' ');
            this.formEvents.append(event);
            this.formEvents.append("=\"");
            this.formEvents.append(action);
            this.formEvents.append('\"');
        }
    }

    public String renderFormEvents() {
        if (this.formEvents != null) {
            return this.formEvents.toString();
        }
        return "";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String renderEnabled() {
        if (this.isEnabled()) {
            return "";
        }
        return " disabled=\"disabled\"";
    }

    public FormElement setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Form getForm() {
        return this.form;
    }

    public String getFormName() {
        if (this.form != null) {
            return this.form.getName();
        }
        return null;
    }

    protected void setForm(Form form) {
        this.form = form;
        if (this.isUsingClientSideValidation()) {
            this.addClientSideValidationClasses();
        }
    }

    protected void addClientSideValidationClasses() {
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public FormElement setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
        return this;
    }

    public boolean equals(Object o) {
        return o instanceof FormElement && this.getName().equals(((FormElement)o).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String renderLabel() {
        return this.renderLabel(null);
    }

    public String renderLabel(String cssClassName) {
        StringBuilder sb = new StringBuilder();
        sb.append("<label for=\"");
        sb.append(this.getName());
        sb.append("\"");
        if (cssClassName != null && cssClassName.length() > 0) {
            sb.append(" class=\"");
            sb.append(cssClassName);
            sb.append("\"");
        }
        sb.append(">");
        sb.append(NetworkHelper.escapeStringForHtml(this.getDisplayName()));
        sb.append("</label>");
        return sb.toString();
    }

    public boolean hasValidationError() {
        return this.validationError;
    }

    protected boolean isUsingHTML5Forms() {
        if (this.useHTML5Forms != null) {
            return this.useHTML5Forms;
        }
        this.useHTML5Forms = this.getForm() != null ? Boolean.valueOf(this.getForm().getApplication().getConfigurator().getLastProperties().getYesNoProperty("UseHTML5Forms", false)) : Boolean.valueOf(false);
        return this.useHTML5Forms;
    }

    protected boolean isUsingClientSideValidation() {
        if (!this.validationEnabled) {
            return false;
        }
        if (this.useClientSideValidation != null) {
            return this.useClientSideValidation;
        }
        this.useClientSideValidation = this.getForm() != null ? Boolean.valueOf(this.getForm().getApplication().getConfigurator().getLastProperties().getYesNoProperty("UseClientSideValidation", false)) : Boolean.valueOf(false);
        return this.useClientSideValidation;
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    public FormElement setClassNames(Set<String> classNames) {
        this.classNames = classNames;
        return this;
    }

    public FormElement addRule(String ruleName, Object rule) {
        if (this.rules == null) {
            this.rules = new HashMap<String, Object>();
        }
        this.rules.put(ruleName, rule);
        return this;
    }

    public FormElement removeRule(String ruleName) {
        if (this.rules != null) {
            this.rules.remove(ruleName);
        }
        return this;
    }

    public Map<String, Object> getRules() {
        return this.rules;
    }

    public FormElement setRules(Map<String, Object> rules) {
        this.rules = rules;
        return this;
    }

    public FormElement setUseHTML5Forms(Boolean useHTML5Forms) {
        this.useHTML5Forms = useHTML5Forms;
        return this;
    }

    public FormElement setUseClientSideValidation(Boolean useClientSideValidation) {
        this.useClientSideValidation = useClientSideValidation;
        return this;
    }
}

