/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.RequestFile;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.StringHelper;
import java.util.HashSet;
import java.util.Set;
import javax.activation.MimeType;

public class FormFileBrowse
extends FormTextField {
    private Set<String> accept = new HashSet<String>();

    public FormFileBrowse(String name, int length, boolean required) {
        super(name, required, length);
    }

    public FormFileBrowse(String name, int length, boolean required, Form form) {
        super(name, required, length, form);
    }

    public FormFileBrowse(String displayName, String name, int length, boolean required) {
        super(name, required, length);
        if (displayName != null) {
            this.setDisplayName(displayName);
        }
    }

    public FormFileBrowse(String displayName, String name, int length, boolean required, Form form) {
        super(name, required, length, form);
        if (displayName != null) {
            this.setDisplayName(displayName);
        }
    }

    public FormFileBrowse(String name, int length) {
        this(name, length, false);
    }

    public FormFileBrowse(String name, int length, Form form) {
        this(name, length, false, form);
    }

    public FormFileBrowse(String name) {
        this(name, 20);
    }

    public FormFileBrowse(String name, Form form) {
        this(name, 20, form);
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public FormFileBrowse setValue(Context context) {
        RequestFile file = context.files().get(this.getName());
        this.setValue(file == null ? null : file.getFilename());
        return this;
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(60);
        buffer.append("<input type=\"file\"");
        buffer.append(this.renderClassName());
        buffer.append(" name=\"");
        buffer.append(this.getName());
        buffer.append("\" size=\"");
        buffer.append(this.getLength());
        buffer.append('\"');
        if (this.isRequired() && this.isUsingHTML5Forms() && this.isValidationEnabled()) {
            buffer.append("\" required=\"required");
        }
        buffer.append(this.renderAcceptString());
        buffer.append(this.renderTabIndex());
        buffer.append(this.renderFormEvents());
        buffer.append(this.renderEnabled());
        buffer.append(this.renderStyle(cssCode));
        buffer.append(this.renderId());
        buffer.append("/>");
        return buffer.toString();
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        if (this.isRequired() && (this.getStringValue() == null || this.getStringValue().length() == 0)) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gffb-empty-e", macros, "gffb-empty-i", macros, "gffb-empty-l", macros);
        }
    }

    public boolean addAcceptedType(String mimeType) {
        return this.accept.add(mimeType);
    }

    public boolean addAcceptedType(MimeType mimeType) {
        return this.accept.add(mimeType.getBaseType());
    }

    public String renderAcceptString() {
        if (this.isUsingHTML5Forms() && CollectionHelper.isNonEmpty(this.accept)) {
            return " accept=\"" + StringHelper.join(",", this.accept) + '\"';
        }
        return "";
    }

    @Override
    protected void setForm(Form pForm) {
        if (pForm != null && StringHelper.isEmpty(pForm.getEncodingType())) {
            pForm.setEncodingType("multipart/form-data");
        }
        super.setForm(pForm);
    }
}

