/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;

public class FormFilePathField
extends FormTextField {
    public static final int CONVENTIONAL_PATH_PREFIX_OFFSET = 3;
    public static final int UNC_PATH_PREFIX_OFFSET = 2;
    private static final char[] BAD_CHARS = new char[]{':', '*', '?', '\"', '<', '>', '|'};

    public FormFilePathField(String name, String value, boolean required, int length, int maxLength) {
        super(name, value, required, length, maxLength);
    }

    public FormFilePathField(String name, String value, boolean required, int length, int maxLength, Form form) {
        super(name, value, required, length, maxLength, form);
    }

    public FormFilePathField(String name, String value, boolean required, int length) {
        this(name, value, required, length, length);
    }

    public FormFilePathField(String name, String value, boolean required, int length, Form form) {
        this(name, value, required, length, length, form);
    }

    public FormFilePathField(String name, boolean required, int length) {
        this(name, "", required, length);
    }

    public FormFilePathField(String name, boolean required, int length, Form form) {
        this(name, "", required, length, form);
    }

    public FormFilePathField(String name, int length) {
        this(name, "", false, length);
    }

    public FormFilePathField(String name, int length, Form form) {
        this(name, "", false, length, form);
    }

    public FormFilePathField(String name) {
        this(name, "", false, 20);
    }

    public FormFilePathField(String name, Form form) {
        this(name, "", false, 20, form);
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        if (this.isRequired() && this.getValue().trim().length() == 0) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gffpf-empty-e", macros, "gffpf-empty-i", macros, "gffpf-empty-l", macros);
        } else if (this.getValue().length() > 4) {
            if (this.isUNCFilePath(this.getValue().trim())) {
                if (this.containsChar(this.getValue().trim(), BAD_CHARS, 2)) {
                    String[] macros = new String[]{this.getDisplayName()};
                    val.setError("gffpf-badchars-e", macros, "gffpf-badchars-i", macros, "gffpf-badchars-l", macros);
                }
            } else if (this.isConventionalFilePath(this.getValue().trim())) {
                if (this.containsChar(this.getValue().trim(), BAD_CHARS, 3)) {
                    String[] macros = new String[]{this.getDisplayName()};
                    val.setError("gffpf-badchars-e", macros, "gffpf-badchars-i", macros, "gffpf-badchars-l", macros);
                }
            } else {
                String[] macros = new String[]{this.getDisplayName()};
                val.setError("gffpf-format-e", macros, "gffpf-format-i", macros, "gffpf-format-l", macros);
            }
        } else if (this.getValue().trim().length() > 0) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gffpf-short-e", macros, "gffpf-short-i", macros, "gffpf-short-l", macros);
        }
    }

    private boolean isConventionalFilePath(String filePath) {
        if (!Character.isLetter(filePath.charAt(0))) {
            return false;
        }
        return filePath.startsWith(":\\", 1) || filePath.startsWith(":/", 1);
    }

    private boolean isUNCFilePath(String filePath) {
        return filePath.startsWith("\\\\") || filePath.startsWith("//");
    }

    private boolean containsChar(String stringToSearch, char[] charsToFind, int startAt) {
        int iIndex = 0;
        while (iIndex < charsToFind.length) {
            if (stringToSearch.indexOf(charsToFind[iIndex], startAt) != -1) {
                return true;
            }
            ++iIndex;
        }
        return false;
    }
}

