/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;

public class FormFloatField
extends FormTextField {
    public static final int DEFAULT_TEXT_LENGTH = 10;
    public static final float DEFAULT_MINIMUM = 0.0f;
    public static final float DEFAULT_MAXIMUM = Float.MAX_VALUE;
    private float min = 0.0f;
    private float max = Float.MAX_VALUE;

    public FormFloatField(String name, String value, boolean required, float min, float max, int length, int maxLength) {
        super(name, value, required, length, maxLength);
        this.setMinimum(min);
        this.setMaximum(max);
    }

    public FormFloatField(String name, String value, boolean required, float min, float max, int length, int maxLength, Form form) {
        super(name, value, required, length, maxLength, form);
        this.setMinimum(min);
        this.setMaximum(max);
    }

    public FormFloatField(String name, String value, boolean required, float min, float max, int length) {
        this(name, value, required, min, max, length, length);
    }

    public FormFloatField(String name, String value, boolean required, float min, float max, int length, Form form) {
        this(name, value, required, min, max, length, length, form);
    }

    public FormFloatField(String name, String value, boolean required, float min, float max) {
        this(name, value, required, min, max, 10);
    }

    public FormFloatField(String name, String value, boolean required, float min, float max, Form form) {
        this(name, value, required, min, max, 10, form);
    }

    public FormFloatField(String name, float value, boolean required, float min, float max) {
        this(name, "" + value, required, min, max, 10);
    }

    public FormFloatField(String name, float value, boolean required, float min, float max, Form form) {
        this(name, "" + value, required, min, max, 10, form);
    }

    public FormFloatField(String name, String value, float min, float max) {
        this(name, value, false, min, max, 10);
    }

    public FormFloatField(String name, String value, float min, float max, Form form) {
        this(name, value, false, min, max, 10, form);
    }

    public FormFloatField(String name, float min, float max) {
        this(name, "", false, min, max, 10);
    }

    public FormFloatField(String name, float min, float max, Form form) {
        this(name, "", false, min, max, 10, form);
    }

    public FormFloatField(String name) {
        this(name, "", false, 0.0f, Float.MAX_VALUE, 10);
    }

    public FormFloatField(String name, Form form) {
        this(name, "", false, 0.0f, Float.MAX_VALUE, 10, form);
    }

    public void setMinimum(float min) {
        this.min = min;
    }

    public float getMinimum() {
        return this.min;
    }

    public String getMinimumAsString() {
        return "" + this.min;
    }

    public void setMaximum(float max) {
        this.max = max;
    }

    public float getMaximum() {
        return this.max;
    }

    public String getMaximumAsString() {
        return "" + this.max;
    }

    public float getFloatValue() {
        try {
            return Float.parseFloat(this.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public void setValue(float newValue) {
        this.setValue("" + newValue);
    }

    @Override
    public int getIntegerValue() {
        return (int)this.getFloatValue();
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        block6: {
            super.requiredValidation(val);
            if (!val.isSet()) {
                try {
                    float floatingValue = Float.parseFloat(this.getValue());
                    if (floatingValue < this.getMinimum()) {
                        String[] macros = new String[]{this.getDisplayName(), this.getMinimumAsString()};
                        val.setError("gfff-low-e", macros, "gfff-low-i", macros, "gfff-low-l", macros);
                    } else if (floatingValue > this.getMaximum()) {
                        String[] macros = new String[]{this.getDisplayName(), this.getMaximumAsString()};
                        val.setError("gfff-high-e", macros, "gfff-high-i", macros, "gfff-high-l", macros);
                    }
                }
                catch (NumberFormatException nfexc) {
                    if (!this.isRequired()) break block6;
                    String[] macros = new String[]{this.getDisplayName(), this.getRenderableValue()};
                    val.setError("gfff-invalid-e", macros, "gfff-invalid-i", macros, "gfff-invalid-l", macros);
                }
            }
        }
    }

    @Override
    protected void addClientSideValidationClasses() {
        super.addClientSideValidationClasses();
        this.addClassName("number");
    }

    @Override
    public String getType() {
        return "text";
    }
}

