/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormHiddenElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;

public class FormHidden
extends FormElement
implements FormHiddenElement {
    public static final String DEFAULT_VALUE = "";
    private String value;

    public FormHidden(String name, String value, boolean required, boolean readOnly) {
        super(name, value, required);
        this.setReadOnly(readOnly);
    }

    public FormHidden(String name, String value, boolean required, boolean readOnly, Form form) {
        super(name, value, required, form);
        this.setReadOnly(readOnly);
    }

    public FormHidden(String name, int value, boolean required, boolean readOnly) {
        super(name, Integer.toString(value), required);
        this.setReadOnly(readOnly);
    }

    public FormHidden(String name, int value, boolean required, boolean readOnly, Form form) {
        super(name, Integer.toString(value), required, form);
        this.setReadOnly(readOnly);
    }

    public FormHidden(String name, String value, boolean readOnly) {
        super(name, value, false);
        this.setReadOnly(readOnly);
    }

    public FormHidden(String name, String value, boolean readOnly, Form form) {
        super(name, value, false, form);
        this.setReadOnly(readOnly);
    }

    public FormHidden(String name, int value, boolean readOnly) {
        super(name, Integer.toString(value), false);
        this.setReadOnly(readOnly);
    }

    public FormHidden(String name, int value, boolean readOnly, Form form) {
        super(name, Integer.toString(value), false, form);
        this.setReadOnly(readOnly);
    }

    public FormHidden(String name, String value) {
        this(name, value, false);
    }

    public FormHidden(String name, String value, Form form) {
        this(name, value, false, form);
    }

    public FormHidden(String name, int value) {
        this(name, Integer.toString(value), false);
    }

    public FormHidden(String name, int value, Form form) {
        this(name, Integer.toString(value), false, form);
    }

    public FormHidden(String name) {
        this(name, DEFAULT_VALUE);
    }

    public FormHidden(String name, Form form) {
        this(name, DEFAULT_VALUE, form);
    }

    @Override
    public FormHidden setValue(String value) {
        if (!this.isReadOnly()) {
            this.value = value;
        }
        return this;
    }

    @Override
    public FormHidden setValue(Context context) {
        this.setValue(context.query().get(this.getName(), this.value));
        return this;
    }

    protected String getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public String getRenderableValue() {
        return NetworkHelper.escapeStringForHtml(this.getValue());
    }

    @Override
    public String getEscapedValue() {
        return StringHelper.escapeSingleQuotes(this.getValue());
    }

    @Override
    public int getIntegerValue() {
        return NumberHelper.parseInt(this.getValue());
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(60);
        buffer.append("<input type=\"hidden\" name=\"");
        buffer.append(this.getName());
        buffer.append("\" id=\"");
        buffer.append(this.getName());
        buffer.append("\" value=\"");
        buffer.append(this.getRenderableValue());
        buffer.append("\"");
        buffer.append(this.renderClassName());
        buffer.append(this.renderStyle(cssCode));
        buffer.append("/>");
        return buffer.toString();
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
    }
}

