/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormHiddenElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormSubmissionElement;
import com.techempower.gemini.form.FormValidation;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;

public class FormHiddenSubmit
extends FormSubmissionElement
implements FormHiddenElement {
    public static final String DEFAULT_VALUE = "";
    private String value;
    private boolean submitted = false;

    public FormHiddenSubmit(String name, String value) {
        super(name, value, false);
    }

    public FormHiddenSubmit(String name) {
        this(name, DEFAULT_VALUE);
    }

    @Override
    public FormElement setValue(String value) {
        if (!this.isReadOnly()) {
            this.value = value;
        }
        return this;
    }

    @Override
    public FormElement setValue(Context context) {
        String contextValue = context.query().get(this.getName(), DEFAULT_VALUE);
        this.submitted = contextValue.length() > 0;
        return this;
    }

    protected String getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public String getRenderableValue() {
        return NetworkHelper.escapeStringForHtml(this.getValue());
    }

    @Override
    public String getEscapedValue() {
        return StringHelper.escapeSingleQuotes(this.getValue());
    }

    @Override
    public int getIntegerValue() {
        return NumberHelper.parseInt(this.getValue());
    }

    @Override
    public String render(String cssCode) {
        return this.render();
    }

    @Override
    public String render() {
        StringBuilder buffer = new StringBuilder(60);
        buffer.append("<input type=\"hidden\" name=\"");
        buffer.append(this.getName());
        buffer.append("\" id=\"");
        buffer.append(this.renderId());
        buffer.append("\" value=\"");
        buffer.append(this.getRenderableValue());
        buffer.append("\" />");
        return buffer.toString();
    }

    @Override
    public FormSingleValidation validate(Context context, FormValidation validation) {
        return null;
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
    }

    @Override
    public boolean isSubmitted() {
        return this.submitted;
    }
}

