/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormSubmissionElement;
import com.techempower.gemini.form.FormValidation;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;

public class FormImageSubmitButton
extends FormSubmissionElement {
    public static final String DEFAULT_VALUE = "Submit";
    private String value = "";
    private String imageName = "";
    private int xCoordinate;
    private int yCoordinate;
    private boolean submitted = false;
    private boolean renderAltEnabled = true;

    public FormImageSubmitButton(String name, String imageName, boolean required, boolean renderAlt) {
        super(name, "", required);
        this.setReadOnly(true);
        this.setImageName(imageName);
        this.setRenderAlt(renderAlt);
    }

    public FormImageSubmitButton(String name, String imageName, boolean required) {
        this(name, imageName, required, true);
    }

    public FormImageSubmitButton(String name, String imageName) {
        this(name, imageName, false, true);
    }

    @Override
    public FormElement setValue(String value) {
        return this;
    }

    @Override
    public FormElement setValue(Context context) {
        this.xCoordinate = context.query().getInt(String.valueOf(this.getName()) + ".x", -1);
        this.yCoordinate = context.query().getInt(String.valueOf(this.getName()) + ".y", -1);
        this.submitted = this.xCoordinate >= 0 && this.yCoordinate >= 0;
        return this;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    protected String getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public String getRenderableValue() {
        return NetworkHelper.escapeStringForHtml(this.getValue());
    }

    @Override
    public String getEscapedValue() {
        return StringHelper.escapeSingleQuotes(this.getValue());
    }

    @Override
    public int getIntegerValue() {
        return 0;
    }

    public String getImageName() {
        return this.imageName;
    }

    public int getX() {
        return this.xCoordinate;
    }

    public int getY() {
        return this.yCoordinate;
    }

    public void setRenderAlt(boolean renderAlt) {
        this.renderAltEnabled = renderAlt;
    }

    public boolean isRenderAltEnabled() {
        return this.renderAltEnabled;
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        return this.renderImage(this.getImageName(), cssCode);
    }

    public String renderImage(String image) {
        return this.renderImage(image, this.getStyle());
    }

    public String renderImage(String image, String cssCode) {
        StringBuilder buffer = new StringBuilder(80);
        buffer.append("<input type=\"image\" name=\"");
        buffer.append(this.getName());
        buffer.append("\" src=\"");
        buffer.append(image);
        if (this.isRenderAltEnabled()) {
            buffer.append("\" alt=\"");
            buffer.append(this.getDisplayName());
        }
        buffer.append("\"");
        buffer.append(this.renderTabIndex());
        buffer.append(this.renderClassName());
        buffer.append(this.renderFormEvents());
        buffer.append(this.renderEnabled());
        buffer.append(this.renderReadOnly());
        buffer.append(this.renderStyle(cssCode));
        buffer.append(this.renderId());
        buffer.append(" border=\"0\" />");
        return buffer.toString();
    }

    @Override
    public FormSingleValidation validate(Context context, FormValidation validation) {
        return null;
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
    }

    @Override
    public boolean isSubmitted() {
        return this.submitted;
    }
}

