/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;
import com.techempower.helper.NumberHelper;

public class FormIntegerField
extends FormTextField {
    public static final int DEFAULT_TEXT_LENGTH = 10;
    public static final long DEFAULT_MINIMUM = 0L;
    public static final long DEFAULT_MAXIMUM = Integer.MAX_VALUE;
    private long min = 0L;
    private long max = Integer.MAX_VALUE;

    public FormIntegerField(String name, String value, boolean required, long min, long max, int length, int maxLength) {
        super(name, value, required, length, maxLength);
        this.setMinimum(min);
        this.setMaximum(max);
        this.setMaxLength(maxLength);
    }

    public FormIntegerField(String name, String value, boolean required, long min, long max, int length, int maxLength, Form form) {
        super(name, value, required, length, form);
        this.setMinimum(min);
        this.setMaximum(max);
        this.setMaxLength(maxLength);
    }

    public FormIntegerField(String name, long value, boolean required, long min, long max, int length, int maxLength) {
        this(name, "" + value, required, min, max);
        this.setLength(length);
        this.setMaxLength(maxLength);
    }

    public FormIntegerField(String name, long value, boolean required, long min, long max, int length, int maxLength, Form form) {
        this(name, "" + value, required, min, max, form);
        this.setLength(length);
        this.setMaxLength(maxLength);
    }

    public FormIntegerField(String name, String value, boolean required, long min, long max, int length) {
        this(name, value, required, min, max, length, length);
    }

    public FormIntegerField(String name, String value, boolean required, long min, long max, int length, Form form) {
        this(name, value, required, min, max, length, length, form);
    }

    public FormIntegerField(String name, Integer value, boolean required, long min, long max, int length) {
        this(name, value == null ? null : "" + value, required, min, max, length, length);
    }

    public FormIntegerField(String name, Integer value, boolean required, long min, long max, int length, Form form) {
        this(name, value == null ? null : "" + value, required, min, max, length, length, form);
    }

    public FormIntegerField(String name, String value, boolean required, long min, long max) {
        this(name, value, required, min, max, 10, 10);
    }

    public FormIntegerField(String name, String value, boolean required, long min, long max, Form form) {
        this(name, value, required, min, max, 10, 10, form);
    }

    public FormIntegerField(String name, Integer value, boolean required, long min, long max) {
        this(name, value == null ? null : "" + value, required, min, max, 10, 10);
    }

    public FormIntegerField(String name, Integer value, boolean required, long min, long max, Form form) {
        this(name, value == null ? null : "" + value, required, min, max, 10, 10, form);
    }

    public FormIntegerField(String name, String value, long min, long max) {
        this(name, value, false, min, max, 10, 10);
    }

    public FormIntegerField(String name, String value, long min, long max, Form form) {
        this(name, value, false, min, max, 10, 10, form);
    }

    public FormIntegerField(String name, long value, long min, long max) {
        this(name, "" + value, false, min, max, 10, 10);
    }

    public FormIntegerField(String name, long value, long min, long max, Form form) {
        this(name, "" + value, false, min, max, 10, 10, form);
    }

    public FormIntegerField(String name, long min, long max) {
        this(name, "", false, min, max, 10, 10);
    }

    public FormIntegerField(String name, long min, long max, Form form) {
        this(name, "", false, min, max, 10, 10, form);
    }

    public FormIntegerField(String name, boolean required, int length) {
        this(name, "", required, 0L, Integer.MAX_VALUE, length);
    }

    public FormIntegerField(String name, boolean required, int length, Form form) {
        this(name, "", required, 0L, Integer.MAX_VALUE, length, form);
    }

    public FormIntegerField(String name) {
        this(name, "", false, 0L, Integer.MAX_VALUE, 10);
    }

    public FormIntegerField(String name, Form form) {
        this(name, "", false, 0L, Integer.MAX_VALUE, 10, form);
    }

    public void setValue(long value) {
        this.setValue("" + value);
    }

    public void setMinimum(long min) {
        this.min = min;
    }

    public int getMinimum() {
        return (int)this.min;
    }

    public long getLongMinimum() {
        return this.min;
    }

    public void setMaximum(long max) {
        this.max = max;
    }

    public int getMaximum() {
        return (int)this.max;
    }

    public long getLongMaximum() {
        return this.max;
    }

    @Override
    public int getIntegerValue() {
        return NumberHelper.parseInt(this.getValue());
    }

    @Override
    public long getLongValue() {
        try {
            return Long.parseLong(this.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        super.requiredValidation(val);
        if (!val.isSet() && (this.getValue().length() > 0 || this.isRequired())) {
            try {
                long longValue = Long.parseLong(this.getValue());
                if (longValue < this.getLongMinimum()) {
                    String[] macros = new String[]{this.getDisplayName(), "" + this.getLongMinimum()};
                    val.setError("gfif-low-e", macros, "gfif-low-i", macros, "gfif-low-l", macros);
                } else if (longValue > this.getLongMaximum()) {
                    String[] macros = new String[]{this.getDisplayName(), "" + this.getLongMaximum()};
                    val.setError("gfif-high-e", macros, "gfif-high-i", macros, "gfif-high-l", macros);
                }
            }
            catch (NumberFormatException nfexc) {
                String[] macros = new String[]{this.getDisplayName(), this.getRenderableValue()};
                val.setError("gfif-invalid-e", macros, "gfif-invalid-i", macros, "gfif-invalid-l", macros);
            }
        }
    }
}

