/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormIntegerField;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.helper.PhoneHelper;
import com.techempower.helper.StringHelper;

public class FormMultiPiecePhoneNumberField
extends FormElement {
    public static final int FIELD_AREA_CODE = 0;
    public static final int FIELD_PREFIX = 1;
    public static final int FIELD_SUFIX = 2;
    public static final int FIELD_EXTENSION = 3;
    private static final String DEFAULT_PHONE_NUMBER_FORMAT = "XXX-XXX-XXXX-XXXXXXX";
    private static final String AUTO_TAB_JAVASCRIPT = "if(this.value.length == this.maxLength && (event.keyCode != 9) && (event.keyCode != 16)){this.form['NEXT_FORM_ELEMENT_NAME'].focus();}";
    private static final String AREA_CODE_FE_SUFIX = "-fmppnf-areaCode";
    private static final String PREFIX_FE_SUFIX = "-fmppnf-prefix";
    private static final String SUFIX_FE_SUFIX = "-fmppnf-sufix";
    private static final String EXTENSION_FE_SUFIX = "-fmppnf-extension";
    private static final String AREA_CODE_DISPLAY_NAME = "-Area Code";
    private static final String PREFIX_DISPLAY_NAME = "-Prefix";
    private static final String SUFFIX_DISPLAY_NAME = "-Suffix";
    private static final String EXTENSION_DISPLAY_NAME = "-Extension";
    private FormIntegerField areaCode;
    private FormIntegerField prefix;
    private FormIntegerField sufix;
    private FormIntegerField extension;
    private String phoneNumberFormat;
    private String extensionLabel;
    private boolean renderExtension;

    public FormMultiPiecePhoneNumberField(String name, String value, boolean required, String phoneNumberFormat) {
        super(name, value, required);
        this.phoneNumberFormat = phoneNumberFormat;
        this.init(name, value, required);
    }

    public FormMultiPiecePhoneNumberField(String name, String value, boolean required, String phoneNumberFormat, Form form) {
        super(name, value, required, form);
        this.phoneNumberFormat = phoneNumberFormat;
        this.init(name, value, required);
    }

    public FormMultiPiecePhoneNumberField(String name, boolean required, String phoneNumberFormat) {
        this(name, "", required, phoneNumberFormat);
    }

    public FormMultiPiecePhoneNumberField(String name, boolean required, String phoneNumberFormat, Form form) {
        this(name, "", required, phoneNumberFormat, form);
    }

    public FormMultiPiecePhoneNumberField(String name) {
        this(name, "", false, "");
    }

    public FormMultiPiecePhoneNumberField(String name, Form form) {
        this(name, "", false, "", form);
    }

    private void init(String name, String value, boolean required) {
        String feName = String.valueOf(name) + AREA_CODE_FE_SUFIX;
        this.areaCode = new FormIntegerField(feName, required, 3);
        this.areaCode.setMinLength(3);
        this.areaCode.setMaxLength(3);
        feName = String.valueOf(name) + PREFIX_FE_SUFIX;
        this.prefix = new FormIntegerField(feName, required, 3);
        this.prefix.setMinLength(3);
        this.prefix.setMaxLength(3);
        feName = String.valueOf(name) + SUFIX_FE_SUFIX;
        this.sufix = new FormIntegerField(feName, required, 4);
        this.sufix.setMinLength(4);
        this.sufix.setMaxLength(4);
        feName = String.valueOf(name) + EXTENSION_FE_SUFIX;
        this.extension = new FormIntegerField(feName, required, 4);
        this.extension.setMinLength(0);
        this.extension.setMaxLength(7);
        this.setDisplayName(name);
        this.setRenderExtension(true);
        this.setValue(value);
    }

    @Override
    public FormElement setValue(String value) {
        if (!this.isReadOnly() && this.areaCode != null) {
            if (StringHelper.isNonEmpty(value)) {
                String phoneNumber = PhoneHelper.format(value, DEFAULT_PHONE_NUMBER_FORMAT);
                String[] parts = phoneNumber.split("-");
                if (parts.length > 0) {
                    this.areaCode.setValue(parts[0]);
                }
                if (parts.length > 1) {
                    this.prefix.setValue(parts[1]);
                }
                if (parts.length > 2) {
                    this.sufix.setValue(parts[2]);
                }
                if (parts.length > 3) {
                    this.extension.setValue(parts[3]);
                } else {
                    this.extension.setValue("");
                }
            } else {
                this.areaCode.setValue(value);
                this.prefix.setValue(value);
                this.sufix.setValue(value);
                this.extension.setValue(value);
            }
        }
        return this;
    }

    @Override
    public FormElement setValue(Context context) {
        this.areaCode.setValue(context);
        this.prefix.setValue(context);
        this.sufix.setValue(context);
        this.extension.setValue(context);
        return this;
    }

    public String getStringValue(String format) {
        StringBuilder toReturn = new StringBuilder();
        if (StringHelper.isNonEmpty(this.areaCode.getStringValue())) {
            toReturn.append(this.areaCode.getStringValue());
        }
        if (StringHelper.isNonEmpty(this.prefix.getStringValue())) {
            toReturn.append(this.prefix.getStringValue());
        }
        if (StringHelper.isNonEmpty(this.sufix.getStringValue())) {
            toReturn.append(this.sufix.getStringValue());
        }
        if (StringHelper.isNonEmpty(this.extension.getStringValue())) {
            toReturn.append(this.extension.getStringValue());
        }
        return PhoneHelper.format(toReturn.toString(), format);
    }

    @Override
    public String getStringValue() {
        return this.getStringValue(this.getPhoneNumberFormat());
    }

    @Override
    public String getRenderableValue() {
        return String.valueOf(this.areaCode.getRenderableValue()) + this.prefix.getRenderableValue() + this.sufix.getRenderableValue() + this.extension.getRenderableValue();
    }

    @Override
    public String getEscapedValue() {
        return String.valueOf(this.areaCode.getEscapedValue()) + this.prefix.getEscapedValue() + this.sufix.getEscapedValue() + this.extension.getEscapedValue();
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(180);
        buffer.append(this.areaCode.render(cssCode));
        buffer.append(this.prefix.render(cssCode));
        buffer.append(this.sufix.render(cssCode));
        if (this.isExtensionRequired() || this.renderExtension()) {
            buffer.append(this.getExtensionLabel());
            buffer.append(this.extension.render(cssCode));
        }
        return buffer.toString();
    }

    public String renderSingle(int fieldNumber) {
        return this.renderSingle("", fieldNumber);
    }

    public String renderSingle(String cssStyle, int fieldNumber) {
        switch (fieldNumber) {
            case 0: {
                return this.areaCode.render(cssStyle);
            }
            case 1: {
                return this.prefix.render(cssStyle);
            }
            case 2: {
                return this.sufix.render(cssStyle);
            }
            case 3: {
                return this.extension.render(cssStyle);
            }
        }
        return "";
    }

    public String getPhoneNumberFormat() {
        if (StringHelper.isEmpty(this.phoneNumberFormat)) {
            return DEFAULT_PHONE_NUMBER_FORMAT;
        }
        return this.phoneNumberFormat;
    }

    public void setPhoneNumberFormat(String string) {
        this.phoneNumberFormat = string;
    }

    @Override
    public FormElement setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        this.setDisplayName(0, String.valueOf(displayName) + AREA_CODE_DISPLAY_NAME);
        this.setDisplayName(1, String.valueOf(displayName) + PREFIX_DISPLAY_NAME);
        this.setDisplayName(2, String.valueOf(displayName) + SUFFIX_DISPLAY_NAME);
        this.setDisplayName(3, String.valueOf(displayName) + EXTENSION_DISPLAY_NAME);
        return this;
    }

    public void setDisplayName(int field, String displayName) {
        switch (field) {
            case 0: {
                this.areaCode.setDisplayName(displayName);
                break;
            }
            case 1: {
                this.prefix.setDisplayName(displayName);
                break;
            }
            case 2: {
                this.sufix.setDisplayName(displayName);
                break;
            }
            case 3: {
                this.extension.setDisplayName(displayName);
                break;
            }
        }
    }

    public void setExtensionRequired(boolean required) {
        this.extension.setRequired(required);
    }

    public boolean isExtensionRequired() {
        return this.extension.isRequired();
    }

    public boolean renderExtension() {
        return this.renderExtension;
    }

    public void setRenderExtension(boolean render) {
        this.renderExtension = render;
    }

    public String getExtensionLabel() {
        if (this.extensionLabel == null) {
            return "";
        }
        return this.extensionLabel;
    }

    public void setExtensionLabel(String string) {
        this.extensionLabel = string;
    }

    public void clearExtensionLabel() {
        this.setExtensionLabel("");
    }

    public void addAutoTabJavascript() {
        String javascript = AUTO_TAB_JAVASCRIPT.replaceAll("NEXT_FORM_ELEMENT_NAME", this.prefix.getName());
        this.areaCode.addFormEvent("onKeyUp", javascript);
        this.areaCode.addFormEvent("onFocus", "this.select()");
        javascript = AUTO_TAB_JAVASCRIPT.replaceAll("NEXT_FORM_ELEMENT_NAME", this.sufix.getName());
        this.prefix.addFormEvent("onKeyUp", javascript);
        this.prefix.addFormEvent("onFocus", "this.select()");
        if (this.isExtensionRequired() || this.renderExtension()) {
            javascript = AUTO_TAB_JAVASCRIPT.replaceAll("NEXT_FORM_ELEMENT_NAME", this.extension.getName());
            this.sufix.addFormEvent("onKeyUp", javascript);
            this.extension.addFormEvent("onFocus", "this.select()");
        }
        this.sufix.addFormEvent("onFocus", "this.select()");
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        this.areaCode.requiredValidation(val);
        this.prefix.requiredValidation(val);
        this.sufix.requiredValidation(val);
        this.extension.requiredValidation(val);
        if ((StringHelper.isEmpty(this.areaCode.getStringValue()) || StringHelper.isEmpty(this.prefix.getStringValue()) || StringHelper.isEmpty(this.sufix.getStringValue())) && StringHelper.isNonEmpty(this.getStringValue())) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError("gfmppnf-missing-e", macros, "gfmppnf-missing-i", macros, "gfmppnf-missing-l", macros);
        }
    }

    @Override
    public void addFormEvent(String event, String action) {
        this.areaCode.addFormEvent(event, action);
        this.prefix.addFormEvent(event, action);
        this.sufix.addFormEvent(event, action);
        this.extension.addFormEvent(event, action);
    }

    @Override
    public FormElement setTabIndex(int order) {
        super.setTabIndex(order);
        if (this.getTabIndex() >= 0) {
            this.areaCode.setTabIndex(this.getTabIndex());
            this.prefix.setTabIndex(this.getTabIndex() + 1);
            this.sufix.setTabIndex(this.getTabIndex() + 2);
            this.extension.setTabIndex(this.getTabIndex() + 3);
        }
        return this;
    }

    @Override
    public FormElement setAutocompleteDisabled(boolean autocompleteDisabled) {
        super.setAutocompleteDisabled(autocompleteDisabled);
        this.areaCode.setAutocompleteDisabled(autocompleteDisabled);
        this.prefix.setAutocompleteDisabled(autocompleteDisabled);
        this.sufix.setAutocompleteDisabled(autocompleteDisabled);
        this.extension.setAutocompleteDisabled(autocompleteDisabled);
        return this;
    }
}

