/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormHiddenElement;
import com.techempower.gemini.form.FormSingleValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class FormNonce
extends FormElement
implements FormHiddenElement {
    private static final String SO_NONCE_LIST = "GeminiFormNonceList";
    private static final Random RANDOM = new Random();
    private final Context context;
    private long longValue;

    public FormNonce(String name, Context context) {
        super(name);
        this.context = context;
    }

    @Override
    public FormNonce setValue(String value) {
        if (value != null) {
            try {
                this.longValue = Long.parseLong(value);
            }
            catch (NumberFormatException nfexc) {
                this.longValue = 0L;
            }
        } else {
            this.longValue = 0L;
        }
        return this;
    }

    @Override
    public FormNonce setValue(Context context) {
        this.setValue(context.query().get(this.getName()));
        return this;
    }

    @Override
    public String getStringValue() {
        return "" + this.longValue;
    }

    @Override
    public String getRenderableValue() {
        return this.getStringValue();
    }

    @Override
    public String getEscapedValue() {
        return this.getStringValue();
    }

    @Override
    public String render() {
        this.longValue = this.storeNonceValue();
        StringBuilder buffer = new StringBuilder(60);
        buffer.append("<input type=\"hidden\" name=\"");
        buffer.append(this.getName());
        buffer.append("\" id=\"");
        buffer.append(this.getName());
        buffer.append("\" value=\"");
        buffer.append(this.getRenderableValue());
        buffer.append("\" />");
        return buffer.toString();
    }

    @Override
    public String render(String cssCode) {
        return this.render();
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        super.requiredValidation(val);
        if (!val.isSet() && !this.goodNonceProvided()) {
            String[] macros = new String[]{};
            val.setError("gfnonce-e", macros, "gfnonce-i", macros, "gfnonce-l", macros);
        }
    }

    protected long storeNonceValue() {
        NonceList nonceList = this.getNonceList();
        return nonceList.store(this.getForm(), this);
    }

    protected boolean goodNonceProvided() {
        NonceList nonceList = this.getNonceList();
        return nonceList.match(this.getForm(), this, this.longValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NonceList getNonceList() {
        NonceList nonceList = (NonceList)this.context.session().getObject(SO_NONCE_LIST);
        if (nonceList == null) {
            FormNonce formNonce = this;
            synchronized (formNonce) {
                nonceList = (NonceList)this.context.session().getObject(SO_NONCE_LIST);
                if (nonceList == null) {
                    nonceList = new NonceList();
                    this.context.session().putObject(SO_NONCE_LIST, nonceList);
                }
            }
        }
        return nonceList;
    }

    static class NonceList {
        public static final int MAXIMUM_NONCES = 100;
        private List<Long> values = new ArrayList<Long>();
        private List<Integer> forms = new ArrayList<Integer>();

        public synchronized boolean match(int formIdentifier, long value) {
            int i = 0;
            while (i < this.values.size()) {
                long candidateValue = this.values.get(i);
                long candidateForm = this.forms.get(i).intValue();
                if (candidateValue == value && candidateForm == (long)formIdentifier) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean match(Form form, FormNonce formNonce, long value) {
            return this.match(this.getIdentifier(form, formNonce).hashCode(), value);
        }

        public synchronized void store(int formIdentifier, long value) {
            if (this.values.size() >= 100) {
                this.values.remove(0);
                this.forms.remove(0);
            }
            this.values.add(value);
            this.forms.add(formIdentifier);
        }

        public void store(String formIdentifier, long value) {
            this.store(formIdentifier.hashCode(), value);
        }

        public long store(String formIdentifier) {
            long newNonce = RANDOM.nextLong();
            this.store(formIdentifier, newNonce);
            return newNonce;
        }

        public long store(Form form, FormNonce formNonce) {
            return this.store(this.getIdentifier(form, formNonce));
        }

        protected String getIdentifier(Form form, FormNonce formNonce) {
            return String.valueOf(form.getName()) + ":" + formNonce.getName();
        }
    }
}

