/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormTextField;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class FormNumberField
extends FormTextField {
    private Double max = null;
    private Double min = null;
    private Double step = null;
    private Type type = Type.NUMBER;

    public FormNumberField(String name) {
        super(name);
    }

    public FormNumberField(String name, Form form) {
        super(name, form);
    }

    public FormNumberField(String displayName, String name, String value, boolean required, int length, int maxLength, Double min) {
        super(displayName, name, value, required, length, maxLength);
        this.setMin(min);
    }

    public FormNumberField(String displayName, String name, String value, boolean required, int length, int maxLength, Double min, Form form) {
        super(displayName, name, value, required, length, maxLength, form);
        this.setMin(min);
    }

    public FormNumberField(String name, Double min, Double max) {
        super(name);
        this.setMin(min);
        this.setMax(max);
    }

    public FormNumberField(String name, Double min, Double max, Form form) {
        super(name, form);
        this.setMin(min);
        this.setMax(max);
    }

    public FormNumberField(String displayName, String name, String value, boolean required, int length, int maxLength, Double min, Double max) {
        super(displayName, name, value, required, length, maxLength);
        this.setMin(min);
        this.setMax(max);
    }

    public FormNumberField(String displayName, String name, String value, boolean required, int length, int maxLength, Double min, Double max, Form form) {
        super(displayName, name, value, required, length, maxLength, form);
        this.setMin(min);
        this.setMax(max);
    }

    public FormNumberField(String name, Double min) {
        super(name);
        this.setMin(min);
    }

    public FormNumberField(String name, Double min, Form form) {
        super(name, form);
        this.setMin(min);
    }

    public FormNumberField(String displayName, String name, String value, boolean required, int length, int maxLength, Double min, Double max, Double step) {
        super(displayName, name, value, required, length, maxLength);
        this.setMin(min);
        this.setMax(max);
        this.step = step;
    }

    public FormNumberField(String displayName, String name, String value, boolean required, int length, int maxLength, Double min, Double max, Double step, Form form) {
        super(displayName, name, value, required, length, maxLength, form);
        this.setMin(min);
        this.setMax(max);
        this.step = step;
    }

    public FormNumberField(String name, Double min, Double max, Double step) {
        super(name);
        this.setMin(min);
        this.setMax(max);
        this.step = step;
    }

    public FormNumberField(String name, Double min, Double max, Double step, Form form) {
        super(name, form);
        this.setMin(min);
        this.setMax(max);
        this.step = step;
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double min) {
        this.min = min;
        if (min != null) {
            this.addRule("min", min);
        }
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double max) {
        this.max = max;
        if (max != null) {
            this.addRule("max", max);
        }
    }

    public Double getStep() {
        return this.step;
    }

    public void setStep(Double step) {
        this.step = step;
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
        super.requiredValidation(val);
        if (!this.isRequired() && StringHelper.isEmptyTrimmed(this.getValue())) {
            return;
        }
        if (!NumberHelper.isNumber(this.getValue())) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError(String.valueOf(this.getResourceNamePrefix()) + "notanumber-e", macros, String.valueOf(this.getResourceNamePrefix()) + "notanumber-i", macros, String.valueOf(this.getResourceNamePrefix()) + "notanumber-l", macros);
        } else if (this.max != null && this.getDoubleValue() > this.max) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError(String.valueOf(this.getResourceNamePrefix()) + "abovemax-e", macros, String.valueOf(this.getResourceNamePrefix()) + "abovemax-i", macros, String.valueOf(this.getResourceNamePrefix()) + "abovemax-l", macros);
        } else if (this.min != null && this.getDoubleValue() < this.min) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError(String.valueOf(this.getResourceNamePrefix()) + "belowmin-e", macros, String.valueOf(this.getResourceNamePrefix()) + "belowmin-i", macros, String.valueOf(this.getResourceNamePrefix()) + "belowmin-l", macros);
        } else if (this.step != null && (this.getDoubleValue() - (this.min == null ? 0.0 : this.min)) % this.step != 0.0) {
            String[] macros = new String[]{this.getDisplayName()};
            val.setError(String.valueOf(this.getResourceNamePrefix()) + "outofstep-e", macros, String.valueOf(this.getResourceNamePrefix()) + "outofstep-i", macros, String.valueOf(this.getResourceNamePrefix()) + "outofstep-l", macros);
        }
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    protected String getResourceNamePrefix() {
        return "gfnf-";
    }

    public double getDoubleValue() {
        if (this.getValue() != null) {
            try {
                return Double.parseDouble(this.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public float getFloatValue() {
        if (this.getValue() != null) {
            try {
                return Float.parseFloat(this.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public byte getByteValue() {
        if (this.getValue() != null) {
            try {
                return Byte.parseByte(this.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public short getShortValue() {
        if (this.getValue() != null) {
            try {
                return Short.parseShort(this.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public long getLongValue() {
        if (this.getValue() != null) {
            try {
                return Long.parseLong(this.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public BigDecimal getBigDecimalValue() {
        if (this.getValue() != null) {
            try {
                return new BigDecimal(this.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public BigInteger getBigIntegerValue() {
        if (this.getValue() != null) {
            try {
                return new BigInteger(this.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public AtomicLong getAtomicLongValue() {
        return new AtomicLong(this.getLongValue());
    }

    public AtomicInteger getAtomicIntegerValue() {
        return new AtomicInteger(this.getIntegerValue());
    }

    public Byte toByte() {
        try {
            return Byte.valueOf(this.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Double toDouble() {
        try {
            return Double.valueOf(this.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Float toFloat() {
        try {
            return Float.valueOf(this.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Integer toInteger() {
        try {
            return Integer.valueOf(this.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Long toLong() {
        try {
            return Long.valueOf(this.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Short toShort() {
        try {
            return Short.valueOf(this.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getType() {
        return this.type.toString().toLowerCase();
    }

    protected String renderMin() {
        if (this.min != null) {
            return " min=\"" + this.min + "\"";
        }
        return "";
    }

    protected String renderMax() {
        if (this.max != null) {
            return " max=\"" + this.max + "\"";
        }
        return "";
    }

    protected String renderStep() {
        if (this.step != null) {
            return " step=\"" + this.step + "\"";
        }
        return "";
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append("<input type=\"");
        buffer.append(this.getType());
        buffer.append("\"");
        buffer.append(this.renderClassName());
        buffer.append(" name=\"");
        buffer.append(this.getName());
        buffer.append("\" value=\"");
        buffer.append(this.getRenderableValue());
        buffer.append("\" size=\"");
        buffer.append(this.getLength());
        if (StringHelper.isNonEmptyTrimmed(this.getPlaceholder())) {
            buffer.append("\" placeholder=\"");
            buffer.append(this.getRenderablePlaceholder());
        }
        if (this.isRequired() && this.isUsingHTML5Forms() && this.isValidationEnabled()) {
            buffer.append("\" required=\"required");
        }
        if (this.isAutofocus()) {
            buffer.append("\" autofocus=\"autofocus");
        }
        buffer.append("\" maxlength=\"");
        buffer.append(this.getMaxLength());
        buffer.append('\"');
        if (this.isUsingClientSideValidation()) {
            buffer.append(" data-validate='");
            buffer.append(this.renderParameterizedValidationRules());
        }
        buffer.append('\'');
        buffer.append(this.renderMax());
        buffer.append(this.renderMin());
        buffer.append(this.renderStep());
        buffer.append(this.renderTabIndex());
        buffer.append(this.renderFormEvents());
        buffer.append(this.renderEnabled());
        buffer.append(this.renderReadOnly());
        buffer.append(this.renderAutocompleteDisabled());
        buffer.append(this.renderListString());
        buffer.append(this.renderId());
        buffer.append(this.renderStyle(cssCode));
        buffer.append("/>");
        return buffer.toString();
    }

    @Override
    protected void addClientSideValidationClasses() {
        this.addClassName("number");
        super.addClientSideValidationClasses();
    }

    public static enum Type {
        NUMBER,
        RANGE;

    }
}

