/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.gemini.form;

import com.techempower.gemini.Context;
import com.techempower.gemini.form.Form;
import com.techempower.gemini.form.FormElement;
import com.techempower.gemini.form.FormSingleValidation;
import com.techempower.gemini.form.FormSubmissionElement;
import com.techempower.gemini.form.FormValidation;
import com.techempower.helper.NetworkHelper;
import com.techempower.helper.StringHelper;

public class FormSubmitButton
extends FormSubmissionElement {
    public static final String DEFAULT_VALUE = "Submit";
    private String value;
    private boolean submitted = false;

    public FormSubmitButton(String name, String value, boolean required) {
        super(name, value, required);
        this.setReadOnly(true);
    }

    public FormSubmitButton(String name, String value, boolean required, Form form) {
        super(name, value, required, form);
        this.setReadOnly(true);
    }

    public FormSubmitButton(String name, String value) {
        this(name, value, false);
    }

    public FormSubmitButton(String name, String value, Form form) {
        this(name, value, false, form);
    }

    @Override
    public FormElement setValue(String value) {
        if (!this.isReadOnly()) {
            this.value = value;
            this.submitted = value.length() > 0;
        }
        return this;
    }

    public void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    @Override
    public FormElement setValue(Context context) {
        String contextValue = context.query().get(this.getName(), "");
        this.submitted = contextValue.length() > 0;
        return this;
    }

    protected String getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public String getRenderableValue() {
        return NetworkHelper.escapeStringForHtml(this.getValue());
    }

    @Override
    public String getEscapedValue() {
        return StringHelper.escapeSingleQuotes(this.getValue());
    }

    @Override
    public int getIntegerValue() {
        return 0;
    }

    @Override
    public String render() {
        return this.render(this.getStyle());
    }

    @Override
    public String render(String cssCode) {
        StringBuilder buffer = new StringBuilder(120);
        buffer.append("<input type=\"submit\"");
        buffer.append(this.renderClassName());
        buffer.append(" name=\"");
        buffer.append(this.getName());
        buffer.append("\" value=\"");
        buffer.append(this.getRenderableValue());
        buffer.append('\"');
        buffer.append(this.renderTabIndex());
        buffer.append(this.renderFormEvents());
        buffer.append(this.renderEnabled());
        if (!this.isUsingHTML5Forms()) {
            buffer.append(this.renderReadOnly());
        }
        buffer.append(this.renderId());
        buffer.append(this.renderStyle(cssCode));
        buffer.append(" />");
        return buffer.toString();
    }

    @Override
    public FormSingleValidation validate(Context context, FormValidation validation) {
        return null;
    }

    @Override
    protected void requiredValidation(FormSingleValidation val) {
    }

    @Override
    public boolean isSubmitted() {
        return this.submitted;
    }
}

